<p align="center"><img src="https://robotraconteurpublicfiles.s3.amazonaws.com/RRheader2.jpg"></p>

# Robot Raconteur Standard Service Definition Types

This repository contains standard service definition types (robdef) for use with Robot Raconteur. Service and driver developers should attempt to use these types whenever possible to allow for interoperability.

## Group 1 Standard Service Definitions

**Group 1 was frozen on 2021-04-05**

Documentation for Group 1 service definitions:

* [com.robotraconteur.action](docs/group1/com.robotraconteur.action.md)
* [com.robotraconteur.actuator](docs/group1/com.robotraconteur.actuator.md)
* [com.robotraconteur.bignum](docs/group1/com.robotraconteur.bignum.md)
* [com.robotraconteur.color](docs/group1/com.robotraconteur.color.md)
* [com.robotraconteur.datatype](docs/group1/com.robotraconteur.datatype.md)
* [com.robotraconteur.datetime.clock](docs/group1/com.robotraconteur.datetime.clock.md)
* [com.robotraconteur.datetime](docs/group1/com.robotraconteur.datetime.md)
* [com.robotraconteur.device.clock](docs/group1/com.robotraconteur.device.clock.md)
* [com.robotraconteur.device.isoch](docs/group1/com.robotraconteur.device.isoch.md)
* [com.robotraconteur.device](docs/group1/com.robotraconteur.device.md)
* [com.robotraconteur.eventlog](docs/group1/com.robotraconteur.eventlog.md)
* [com.robotraconteur.fiducial](docs/group1/com.robotraconteur.fiducial.md)
* [com.robotraconteur.geometry](docs/group1/com.robotraconteur.geometry.md)
* [com.robotraconteur.geometry.shapes](docs/group1/com.robotraconteur.geometry.shapes.md)
* [com.robotraconteur.geometryf](docs/group1/com.robotraconteur.geometryf.md)
* [com.robotraconteur.geometryi](docs/group1/com.robotraconteur.geometryi.md)
* [com.robotraconteur.gps](docs/group1/com.robotraconteur.gps.md)
* [com.robotraconteur.hid.joystick](docs/group1/com.robotraconteur.hid.joystick.md)
* [com.robotraconteur.identifier](docs/group1/com.robotraconteur.identifier.md)
* [com.robotraconteur.image](docs/group1/com.robotraconteur.image.md)
* [com.robotraconteur.imaging.camerainfo](docs/group1/com.robotraconteur.imaging.camerainfo.md)
* [com.robotraconteur.imaging](docs/group1/com.robotraconteur.imaging.md)
* [com.robotraconteur.imu](docs/group1/com.robotraconteur.imu.md)
* [com.robotraconteur.laserscan](docs/group1/com.robotraconteur.laserscan.md)
* [com.robotraconteur.laserscanner](docs/group1/com.robotraconteur.laserscanner.md)
* [com.robotraconteur.lighting](docs/group1/com.robotraconteur.lighting.md)
* [com.robotraconteur.objectrecognition](docs/group1/com.robotraconteur.objectrecognition.md)
* [com.robotraconteur.octree](docs/group1/com.robotraconteur.octree.md)
* [com.robotraconteur.param](docs/group1/com.robotraconteur.param.md)
* [com.robotraconteur.pid](docs/group1/com.robotraconteur.pid.md)
* [com.robotraconteur.pointcloud](docs/group1/com.robotraconteur.pointcloud.md)
* [com.robotraconteur.pointcloud.sensor](docs/group1/com.robotraconteur.pointcloud.sensor.md)
* [com.robotraconteur.resource.device](docs/group1/com.robotraconteur.resource.device.md)
* [com.robotraconteur.resource](docs/group1/com.robotraconteur.resource.md)
* [com.robotraconteur.robotics.joints](docs/group1/com.robotraconteur.robotics.joints.md)
* [com.robotraconteur.robotics.payload](docs/group1/com.robotraconteur.robotics.payload.md)
* [com.robotraconteur.robotics.robot](docs/group1/com.robotraconteur.robotics.robot.md)
* [com.robotraconteur.robotics.tool](docs/group1/com.robotraconteur.robotics.tool.md)
* [com.robotraconteur.robotics.trajectory](docs/group1/com.robotraconteur.robotics.trajectory.md)
* [com.robotraconteur.sensor](docs/group1/com.robotraconteur.sensor.md)
* [com.robotraconteur.sensordata](docs/group1/com.robotraconteur.sensordata.md)
* [com.robotraconteur.servo](docs/group1/com.robotraconteur.servo.md)
* [com.robotraconteur.signal](docs/group1/com.robotraconteur.signal.md)
* [com.robotraconteur.units](docs/group1/com.robotraconteur.units.md)
* [com.robotraconteur.uuid](docs/group1/com.robotraconteur.uuid.md)


Group 2 is under development, and should be considered unstable.

## Info Yaml Files

Drivers use Yaml files to provide information about devices and services to clients. See the 
[Info Yaml Files](docs/info_files/README.md) documentation for more information.
