#!/bin/bash
#
#  post-install.sh
#  Alma 10
#  (c) Thomas Lange 2020-2025

prefix=$1
CH="chroot ${prefix}"

if [ ! -d "${prefix}" ]; then
  echo "Serious error - the named directory doesn't exist."
  exit
fi

# rpm's can now be removed
rm -f ${prefix}/*.rpm

# add command, that are normally executed in postinst or similar

# glibc
$CH /sbin/ldconfig

# filesystem
mkdir ${prefix}/usr/lib/debug/usr
mkdir ${prefix}/usr/lib/debug/usr/bin
mkdir ${prefix}/usr/lib/debug/usr/sbin
mkdir ${prefix}/usr/lib/debug/usr/lib
mkdir ${prefix}/usr/lib/debug/usr/lib64
ln -s usr/bin   $prefix/usr/lib/debug/bin
ln -s usr/lib   $prefix/usr/lib/debug/lib
ln -s usr/lib64 $prefix/usr/lib/debug/lib64
ln -s usr/sbin  $prefix/usr/lib/debug/sbin
ln -s ../.dwz   $prefix/usr/lib/debug/usr/.dwz
ln -s usr/bin   $prefix/bin
ln -s usr/sbin  $prefix/sbin
ln -s usr/lib   $prefix/lib
ln -s usr/lib64 $prefix/lib64

mv $prefix/var/run/* $prefix/run
rmdir $prefix/var/run
ln -s ../run $prefix/var/run
ln -s ../run/lock $prefix/var/lock
touch ${prefix}/etc/kdump.conf

# authselect-libs
$CH authselect select local --force --nobackup
$CH authselect apply-changes

# dbus
$CH groupadd -r -g 81 dbus
$CH useradd -c 'System message bus' -u 81 -g 81 -s /sbin/nologin -r -d '/' dbus
$CH /usr/lib/systemd/systemd-update-helper install-system-units dbus-broker.service

#dbus-common
$CH /usr/lib/systemd/systemd-update-helper install-system-units dbus.socket

#dnf
$CH /usr/lib/systemd/systemd-update-helper install-system-units dnf-makecache.timer

# libutempter
$CH groupadd -g 22 -r -f utmp
$CH groupadd -g 35 -r -f utempter

# p11-kit-trust
$CH update-alternatives --install /usr/lib64/libnssckbi.so libnssckbi.so.x86_64 /usr/lib64/pkcs11/p11-kit-trust.so 30

# systemd
$CH groupadd -r systemd-oom
$CH useradd -r -l -g systemd-oom -d / -s /sbin/nologin -c "systemd Userspace OOM Killer" systemd-oom
$CH groupadd -r input
$CH groupadd -r -g 36 kvm
$CH groupadd -r render
$CH groupadd -r -g 190 systemd-journal
$CH groupadd -r systemd-coredump
$CH useradd -r -l -g systemd-coredump -d / -s /sbin/nologin -c "systemd Core Dumper" systemd-coredump &>/dev/null || :
$CH groupadd -r -g 193 systemd-resolve
$CH useradd -r -u 193 -l -g systemd-resolve -d / -s /sbin/nologin -c "systemd Resolver" systemd-resolve &>/dev/null || :

# systemd
$CH systemd-sysusers
$CH systemd-tmpfiles --create
$CH systemctl preset-all
$CH systemctl --global preset-all

# systemd-udev
$CH /usr/lib/systemd/systemd-update-helper install-system-units systemd-udev{d,-settle,-trigger}.service systemd-udevd-{control,kernel}.socket systemd-boot-update.service systemd-pstore.service remote-cryptsetup.target

# tpm2-tss, already exists
#$CH groupadd -f -g '59' -r 'tss'
#$CH useradd -r -u '59' -g 'tss' -d '/' -s '/usr/sbin/nologin' -c 'Account used for TPM access' 'tss'

# util-linux
$CH /usr/lib/systemd/systemd-update-helper install-system-units fstrim.{service,timer}

# ca-certificates
$CH ca-legacy install
$CH update-ca-trust

echo "  Updating package"
$CH dnf -y update

echo "  cleaning up..."
$CH dnf clean all

umount ${prefix}/proc
umount ${prefix}/sys

echo "  post-install.sh : done."
