# panel_row.py
#
# Copyright 2024 Hari Rana (TheEvilSkeleton)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later


from gi.repository import Adw, GObject, Gtk


@Gtk.Template.from_resource("/page/tesk/Refine/widgets/panel-row.ui")
class PanelRow(Adw.PreferencesRow):
    """An `Adw.PreferencesRow` for displaying information of a page."""

    __gtype_name__ = "PanelRow"

    @GObject.Property(type=Adw.PreferencesPage)
    def page(self) -> Adw.PreferencesPage:
        """Get or set the `Adw.PreferencesPage` of the row."""
        return self._page

    @page.setter  # type: ignore [no-redef]
    def page(self, page: Adw.PreferencesPage) -> None:
        self._page = page

    @GObject.Property(type=str, default="")
    def icon_name(self) -> str:
        """Get or set the icon name."""
        return self._icon_name

    @icon_name.setter  # type: ignore [no-redef]
    def icon_name(self, icon_name: str) -> None:
        self._icon_name = icon_name
