% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_inflated.R
\name{dist_inflated}
\alias{dist_inflated}
\title{Inflate a value of a probability distribution}
\usage{
dist_inflated(dist, prob, x = 0)
}
\arguments{
\item{dist}{The distribution(s) to inflate.}

\item{prob}{The added probability of observing \code{x}.}

\item{x}{The value to inflate. The default of \code{x = 0} is for zero-inflation.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Inflated distributions add extra probability mass at a specific value,
most commonly zero (zero-inflation). These distributions are useful for
modeling data with excess observations at a particular value compared to
what the base distribution would predict. Common applications include
zero-inflated Poisson or negative binomial models for count data with
many zeros.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_inflated.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_inflated.html}

In the following, let \eqn{Y} be an inflated random variable based on
a base distribution \eqn{X}, with inflation value \code{x} = \eqn{c} and
inflation probability \code{prob} = \eqn{p}.

\strong{Support}: Same as the base distribution, but with additional
probability mass at \eqn{c}

\strong{Mean}: (when \code{x} is numeric)

\deqn{
    E(Y) = p \cdot c + (1-p) \cdot E(X)
  }{
    E(Y) = p * c + (1-p) * E(X)
  }

\strong{Variance}: (when \code{x = 0})

\deqn{
    \text{Var}(Y) = (1-p) \cdot \text{Var}(X) + p(1-p) \cdot [E(X)]^2
  }{
    Var(Y) = (1-p) * Var(X) + p(1-p) * [E(X)]^2
  }

For non-zero inflation values, the variance is not computed in closed form.

\strong{Probability mass/density function (p.m.f/p.d.f)}:

For discrete distributions:
\deqn{
    f_Y(y) = \begin{cases}
      p + (1-p) \cdot f_X(c) & \text{if } y = c \\
      (1-p) \cdot f_X(y) & \text{if } y \neq c
    \end{cases}
  }{
    f_Y(y) = p + (1-p) * f_X(c) if y = c, (1-p) * f_X(y) if y != c
  }

For continuous distributions:
\deqn{
    f_Y(y) = \begin{cases}
      p & \text{if } y = c \\
      (1-p) \cdot f_X(y) & \text{if } y \neq c
    \end{cases}
  }{
    f_Y(y) = p if y = c, (1-p) * f_X(y) if y != c
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F_Y(q) = \begin{cases}
      (1-p) \cdot F_X(q) & \text{if } q < c \\
      p + (1-p) \cdot F_X(q) & \text{if } q \geq c
    \end{cases}
  }{
    F_Y(q) = (1-p) * F_X(q) if q < c, p + (1-p) * F_X(q) if q >= c
  }

\strong{Quantile function}:

The quantile function is computed numerically by inverting the
inflated CDF, accounting for the jump in probability at the
inflation point.
}
\examples{
# Zero-inflated Poisson
dist <- dist_inflated(dist_poisson(lambda = 2), prob = 0.3, x = 0)

dist
mean(dist)
variance(dist)

generate(dist, 10)

density(dist, 0)
density(dist, 1)

cdf(dist, 2)

quantile(dist, 0.5)

}
