% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-day.R
\name{year-month-day-getters}
\alias{year-month-day-getters}
\alias{get_year.clock_year_month_day}
\alias{get_month.clock_year_month_day}
\alias{get_day.clock_year_month_day}
\alias{get_hour.clock_year_month_day}
\alias{get_minute.clock_year_month_day}
\alias{get_second.clock_year_month_day}
\alias{get_millisecond.clock_year_month_day}
\alias{get_microsecond.clock_year_month_day}
\alias{get_nanosecond.clock_year_month_day}
\title{Getters: year-month-day}
\usage{
\method{get_year}{clock_year_month_day}(x)

\method{get_month}{clock_year_month_day}(x)

\method{get_day}{clock_year_month_day}(x)

\method{get_hour}{clock_year_month_day}(x)

\method{get_minute}{clock_year_month_day}(x)

\method{get_second}{clock_year_month_day}(x)

\method{get_millisecond}{clock_year_month_day}(x)

\method{get_microsecond}{clock_year_month_day}(x)

\method{get_nanosecond}{clock_year_month_day}(x)
}
\arguments{
\item{x}{\verb{[clock_year_month_day]}

A year-month-day to get the component from.}
}
\value{
The component.
}
\description{
These are year-month-day methods for the \link[=clock-getters]{getter generics}.
\itemize{
\item \code{get_year()} returns the Gregorian year.
\item \code{get_month()} returns the month of the year.
\item \code{get_day()} returns the day of the month.
\item There are sub-daily getters for extracting more precise components.
}
}
\examples{
x <- year_month_day(2019, 1:3, 5:7, 1, 20, 30)

get_month(x)
get_day(x)
get_second(x)

# Cannot extract more precise components
y <- year_month_day(2019, 1)
try(get_day(y))

# Cannot extract components that don't exist for this calendar
try(get_quarter(x))
}
