# logserver

pager designed for rapid navigation with multiple keyword searching on giant log files

## requirements

- libz-dev
- libncurses-dev
- catch2 (for unit tests)

That's it.

## building

project uses cmake:

- create a build subdirectory
- cmake ..
- make
- optionally sudo make install or copy logserver to your $PATH

## packaging

- cmake -B build -S . -DCMAKE_BUILD_TYPE=Release
- cmake --build build
- cpack --config build/CPackConfig.cmake


## using

- command-stdout | logserver
- logserver filename

## keybindings

h for help!

              q: quit
              h: help page (this)
              n: toggle line numbers
              c: toggle colours
              !: insert line marker
              s: save current line to /tmp/logserver_save
              S: save current view to /tmp/logserver_save
              b: break a long line into reasonable length new lines
              B: breaks the line using the next keypress as breakpoint (e.g., comma, semicolon, etc.)
              i: give more info for a line (repeat to try harder)
              I: give more info for a bunch of lines around (repeat to try harder and farther)
              t: toggle tab inference
              dd: delete line
              |: begin a pipe command
              :: go to a line number
              t: turn on tab inferrance and tabbbing
              y: copy current line to system clipboard
              #: write a comment, gets saved in a file called storytime.txt with nearby context lines
              e: edit the current line (useful to tidy for a screenshot)
              S: save the file (takes a filename)
              s: save the current line (takes a filename)
              C: wipes entire contents but keeps streaming in new data


     (navigation)
         arrows: move in that direction
      G or HOME: move to top line
       T or END: move to bottom line
        PAGE-UP: move up some lines (shift for many lines)
      PAGE-DOWN: move down some lines (shift for many lines)
     shift-HOME: move to start of current line
      shift-END: move to end of current line
     shift-LEFT: move to previous matching keyword on line
    shift-RIGHT: move to next matching keyword on line
     shift-DOWN: move to next matching keyword downwards
       shift-UP: move to next matching keyword upwards
              J: set a jump point at line
              j: go to next jump point

    (search)
              /: start a search
              ^: start a left anchored search
              $: start a right anchored search
              \: start a remove search
              +: add lines of context around matches
              -: remove lines of context around matches      
              p: pin the current line so it appears in searches
          ENTER: finish search term
      BACKSPACE: remove the last search term
             TAB: switch between ALL (off), AND and OR mode for search terms

     (stacks)
               %: filter current matching lines into a new page, if in ALL mode then takes content between nearest line markers in each direction (i.e., from !)
             ESC: pop current page, go back to old one
           ENTER: finish a pipe and run command to new view
               <: moves left on view stack
               >: moves right on view stack

