//===-- lib/runtime/iostat.cpp ----------------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#include "flang-rt/runtime/iostat.h"

namespace Fortran::runtime::io {
RT_OFFLOAD_API_GROUP_BEGIN

const char *IostatErrorString(int iostat) {
  switch (iostat) {
  case IostatOk:
    return "No error";
  case IostatEnd:
    return "End of file during input";
  case IostatEor:
    return "End of record during non-advancing input";
  case IostatUnflushable:
    return "FLUSH not possible";
  case IostatInquireInternalUnit:
    return "INQUIRE on internal unit";
  case IostatGenericError:
    return "I/O error"; // dummy value, there's always a message
  case IostatRecordWriteOverrun:
    return "Excessive output to fixed-size record";
  case IostatRecordReadOverrun:
    return "Excessive input from fixed-size record";
  case IostatInternalWriteOverrun:
    return "Internal write overran available records";
  case IostatErrorInFormat:
    return "Bad FORMAT";
  case IostatErrorInKeyword:
    return "Bad keyword argument value";
  case IostatEndfileDirect:
    return "ENDFILE on direct-access file";
  case IostatEndfileUnwritable:
    return "ENDFILE on read-only file";
  case IostatOpenBadRecl:
    return "OPEN with bad RECL= value";
  case IostatOpenUnknownSize:
    return "OPEN of file of unknown size";
  case IostatOpenBadAppend:
    return "OPEN(POSITION='APPEND') of unpositionable file";
  case IostatWriteToReadOnly:
    return "Attempted output to read-only file";
  case IostatReadFromWriteOnly:
    return "Attempted input from write-only file";
  case IostatBackspaceNonSequential:
    return "BACKSPACE on non-sequential file";
  case IostatBackspaceAtFirstRecord:
    return "BACKSPACE at first record";
  case IostatRewindNonSequential:
    return "REWIND on non-sequential file";
  case IostatWriteAfterEndfile:
    return "WRITE after ENDFILE";
  case IostatFormattedIoOnUnformattedUnit:
    return "Formatted I/O on unformatted file";
  case IostatUnformattedIoOnFormattedUnit:
    return "Unformatted I/O on formatted file";
  case IostatListIoOnDirectAccessUnit:
    return "List-directed or NAMELIST I/O on direct-access file";
  case IostatUnformattedChildOnFormattedParent:
    return "Unformatted child I/O on formatted parent unit";
  case IostatFormattedChildOnUnformattedParent:
    return "Formatted child I/O on unformatted parent unit";
  case IostatChildInputFromOutputParent:
    return "Child input from output parent unit";
  case IostatChildOutputToInputParent:
    return "Child output to input parent unit";
  case IostatShortRead:
    return "Read from external unit returned insufficient data";
  case IostatMissingTerminator:
    return "Sequential record missing its terminator";
  case IostatBadUnformattedRecord:
    return "Erroneous unformatted sequential file record structure";
  case IostatUTF8Decoding:
    return "UTF-8 decoding error";
  case IostatUnitOverflow:
    return "UNIT number is out of range";
  case IostatBadRealInput:
    return "Bad REAL input value";
  case IostatBadScaleFactor:
    return "Bad REAL output scale factor (kP)";
  case IostatBadAsynchronous:
    return "READ/WRITE(ASYNCHRONOUS='YES') on unit without "
           "OPEN(ASYNCHRONOUS='YES')";
  case IostatBadWaitUnit:
    return "WAIT(UNIT=) for a bad or unconnected unit number";
  case IostatBOZInputOverflow:
    return "B/O/Z input value overflows variable";
  case IostatIntegerInputOverflow:
    return "Integer input value overflows variable";
  case IostatRealInputOverflow:
    return "Real or complex input value overflows type";
  case IostatCannotReposition:
    return "Attempt to reposition a unit which is connected to a file that can "
           "only be processed sequentially";
  case IostatOpenAlreadyConnected:
    return "OPEN of file already connected to another unit";
  case IostatBadWaitId:
    return "WAIT(ID=nonzero) for an ID value that is not a pending operation";
  case IostatTooManyAsyncOps:
    return "Too many asynchronous operations pending on unit";
  case IostatBadBackspaceUnit:
    return "BACKSPACE on unconnected unit";
  case IostatBadUnitNumber:
    return "Negative unit number is not allowed";
  case IostatBadFlushUnit:
    return "FLUSH attempted on a bad or unconnected unit number";
  case IostatBadOpOnChildUnit:
    return "Impermissible I/O statement on child I/O unit";
  case IostatBadNewUnit:
    return "NEWUNIT= without FILE= or STATUS='SCRATCH'";
  case IostatBadListDirectedInputSeparator:
    return "List-directed input value has trailing unused characters";
  case IostatNonExternalDefinedUnformattedIo:
    return "Defined unformatted I/O without an external unit";
  default:
    return nullptr;
  }
}

RT_OFFLOAD_API_GROUP_END

} // namespace Fortran::runtime::io
