
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_IJ_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AuxParCSRMatrixCreate( hypre_AuxParCSRMatrix **aux_matrix, HYPRE_Int local_num_rows, HYPRE_Int local_num_cols, HYPRE_Int *sizes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AuxParCSRMatrixCreate)( aux_matrix, local_num_rows, local_num_cols, sizes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AuxParCSRMatrixDestroy( hypre_AuxParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AuxParCSRMatrixDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AuxParCSRMatrixInitialize( hypre_AuxParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AuxParCSRMatrixInitialize)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AuxParCSRMatrixInitialize_v2( hypre_AuxParCSRMatrix *matrix, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AuxParCSRMatrixInitialize_v2)( matrix, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AuxParCSRMatrixSetRownnz( hypre_AuxParCSRMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AuxParCSRMatrixSetRownnz)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AuxParVectorCreate( hypre_AuxParVector **aux_vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AuxParVectorCreate)( aux_vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AuxParVectorDestroy( hypre_AuxParVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AuxParVectorDestroy)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AuxParVectorInitialize_v2( hypre_AuxParVector *vector, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AuxParVectorInitialize_v2)( vector, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FillResponseIJOffProcVals( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FillResponseIJOffProcVals)( p_recv_contact_buf, contact_size, contact_proc, ro, comm, p_send_response_buf, response_message_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FindProc( HYPRE_BigInt *list, HYPRE_BigInt value, HYPRE_Int list_length )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FindProc)( list, value, list_length );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixAddParCSR( HYPRE_Complex alpha, hypre_IJMatrix *matrix_A, HYPRE_Complex beta, hypre_IJMatrix *matrix_B, hypre_IJMatrix *matrix_C )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixAddParCSR)( alpha, matrix_A, beta, matrix_B, matrix_C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixAddToValuesOMPParCSR( hypre_IJMatrix *matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixAddToValuesOMPParCSR)( matrix, nrows, ncols, rows, row_indexes, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixAddToValuesParCSR( hypre_IJMatrix *matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixAddToValuesParCSR)( matrix, nrows, ncols, rows, row_indexes, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixAssembleOffProcValsParCSR( hypre_IJMatrix *matrix, HYPRE_Int off_proc_i_indx, HYPRE_Int max_off_proc_elmts, HYPRE_Int current_num_elmts, HYPRE_MemoryLocation memory_location, HYPRE_BigInt *off_proc_i, HYPRE_BigInt *off_proc_j, HYPRE_Complex *off_proc_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixAssembleOffProcValsParCSR)( matrix, off_proc_i_indx, max_off_proc_elmts, current_num_elmts, memory_location, off_proc_i, off_proc_j, off_proc_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixAssembleParCSR( hypre_IJMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixAssembleParCSR)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixCreateAssumedPartition( hypre_IJMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixCreateAssumedPartition)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixCreateParCSR( hypre_IJMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixCreateParCSR)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixDestroyParCSR( hypre_IJMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixDestroyParCSR)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixGetColPartitioning( HYPRE_IJMatrix matrix, HYPRE_BigInt **col_partitioning )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixGetColPartitioning)( matrix, col_partitioning );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixGetRowCountsParCSR( hypre_IJMatrix *matrix, HYPRE_Int nrows, HYPRE_BigInt *rows, HYPRE_Int *ncols )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixGetRowCountsParCSR)( matrix, nrows, rows, ncols );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixGetRowPartitioning( HYPRE_IJMatrix matrix, HYPRE_BigInt **row_partitioning )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixGetRowPartitioning)( matrix, row_partitioning );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixGetValuesParCSR( hypre_IJMatrix *matrix, HYPRE_Int nrows, HYPRE_Int *ncols, HYPRE_BigInt *rows, HYPRE_Int *row_indexes, HYPRE_BigInt *cols, HYPRE_Complex *values, HYPRE_Int zero_out )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixGetValuesParCSR)( matrix, nrows, ncols, rows, row_indexes, cols, values, zero_out );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixInitializeParCSR( hypre_IJMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixInitializeParCSR)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixInitializeParCSR_v2( hypre_IJMatrix *matrix, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixInitializeParCSR_v2)( matrix, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixMigrateParCSR( hypre_IJMatrix *matrix, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixMigrateParCSR)( matrix, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixNormParCSR( hypre_IJMatrix *matrix, HYPRE_Real *norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixNormParCSR)( matrix, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixRead( const char *filename, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr, HYPRE_Int is_mm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixRead)( filename, comm, type, matrix_ptr, is_mm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixReadBinary( const char *prefixname, MPI_Comm comm, HYPRE_Int type, HYPRE_IJMatrix *matrix_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixReadBinary)( prefixname, comm, type, matrix_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetConstantValuesParCSR( hypre_IJMatrix *matrix, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetConstantValuesParCSR)( matrix, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetDiagOffdSizesParCSR( hypre_IJMatrix *matrix, const HYPRE_Int *diag_sizes, const HYPRE_Int *offdiag_sizes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetDiagOffdSizesParCSR)( matrix, diag_sizes, offdiag_sizes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetEarlyAssembleParCSR( hypre_IJMatrix *matrix, HYPRE_Int early_assemble )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetEarlyAssembleParCSR)( matrix, early_assemble );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetGrowFactorParCSR( hypre_IJMatrix *matrix, HYPRE_Real factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetGrowFactorParCSR)( matrix, factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetInitAllocationParCSR( hypre_IJMatrix *matrix, HYPRE_Int factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetInitAllocationParCSR)( matrix, factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetMaxOffProcElmtsParCSR( hypre_IJMatrix *matrix, HYPRE_Int max_off_proc_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetMaxOffProcElmtsParCSR)( matrix, max_off_proc_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetObject( HYPRE_IJMatrix matrix, void *object )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetObject)( matrix, object );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetRowSizesParCSR( hypre_IJMatrix *matrix, const HYPRE_Int *sizes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetRowSizesParCSR)( matrix, sizes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetValuesOMPParCSR( hypre_IJMatrix *matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetValuesOMPParCSR)( matrix, nrows, ncols, rows, row_indexes, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixSetValuesParCSR( hypre_IJMatrix *matrix, HYPRE_Int nrows, HYPRE_Int *ncols, const HYPRE_BigInt *rows, const HYPRE_Int *row_indexes, const HYPRE_BigInt *cols, const HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixSetValuesParCSR)( matrix, nrows, ncols, rows, row_indexes, cols, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJMatrixTransposeParCSR( hypre_IJMatrix *matrix_A, hypre_IJMatrix *matrix_AT )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJMatrixTransposeParCSR)( matrix_A, matrix_AT );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorAddToValuesPar( hypre_IJVector *vector, HYPRE_Int num_values, const HYPRE_BigInt *indices, const HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorAddToValuesPar)( vector, num_values, indices, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorAssembleOffProcValsPar( hypre_IJVector *vector, HYPRE_Int max_off_proc_elmts, HYPRE_Int current_num_elmts, HYPRE_MemoryLocation memory_location, HYPRE_BigInt *off_proc_i, HYPRE_Complex *off_proc_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorAssembleOffProcValsPar)( vector, max_off_proc_elmts, current_num_elmts, memory_location, off_proc_i, off_proc_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorAssemblePar( hypre_IJVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorAssemblePar)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorCreateAssumedPartition( hypre_IJVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorCreateAssumedPartition)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorCreatePar( hypre_IJVector *vector, HYPRE_BigInt *IJpartitioning )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorCreatePar)( vector, IJpartitioning );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorDestroyPar( hypre_IJVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorDestroyPar)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorDistribute( HYPRE_IJVector vector, const HYPRE_Int *vec_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorDistribute)( vector, vec_starts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorDistributePar( hypre_IJVector *vector, const HYPRE_Int *vec_starts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorDistributePar)( vector, vec_starts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorGetValuesPar( hypre_IJVector *vector, HYPRE_Int num_values, const HYPRE_BigInt *indices, HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorGetValuesPar)( vector, num_values, indices, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorInitializePar( hypre_IJVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorInitializePar)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorInitializeParShell( hypre_IJVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorInitializeParShell)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorInitializePar_v2( hypre_IJVector *vector, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorInitializePar_v2)( vector, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorMigrateParCSR( hypre_IJVector *vector, HYPRE_MemoryLocation memory_location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorMigrateParCSR)( vector, memory_location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorReadBinary( MPI_Comm comm, const char *filename, HYPRE_Int type, HYPRE_IJVector *vector_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorReadBinary)( comm, filename, type, vector_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorSetComponentPar( hypre_IJVector *vector, HYPRE_Int component )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorSetComponentPar)( vector, component );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorSetConstantValuesPar( hypre_IJVector *vector, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorSetConstantValuesPar)( vector, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorSetMaxOffProcElmtsPar( hypre_IJVector *vector, HYPRE_Int max_off_proc_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorSetMaxOffProcElmtsPar)( vector, max_off_proc_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorSetParData( hypre_IJVector *vector, HYPRE_Complex *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorSetParData)( vector, data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorSetTagsPar( hypre_IJVector *vector, HYPRE_Int owns_tags, HYPRE_Int num_tags, HYPRE_Int *tags )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorSetTagsPar)( vector, owns_tags, num_tags, tags );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorSetValuesPar( hypre_IJVector *vector, HYPRE_Int num_values, const HYPRE_BigInt *indices, const HYPRE_Complex *values )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorSetValuesPar)( vector, num_values, indices, values );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorZeroValues( HYPRE_IJVector vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorZeroValues)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IJVectorZeroValuesPar( hypre_IJVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IJVectorZeroValuesPar)( vector );
}


#endif

