/*
 * DIGITAL DOWN CONVERTER FILTERS - OPTIMIZED
 * Auto-generated by generate_filters_multi.py
 * Generated: 2026-01-17
 *
 * This header provides multiple filter configurations for DDC:
 *
 * | Config       | Taps | Delay | Rejection | Use Case                     |
 * |--------------|------|-------|-----------|------------------------------|
 * | 47_OPT       |  47  |   12  |  ~63 dB   | Default base DDC (Remez)     |
 * | 65_POW2      |  65  |   16  |  ~66 dB   | Optimized, branchless wrap   |
 * | 83_HIGHPERF  |  83  |   21  | >100 dB   | High dynamic range           |
 * | 33_FAST      |  33  |    8  |  ~62 dB   | Decimation stages 0-2        |
 * | 17_FAST      |  17  |    4  |  ~59 dB   | Decimation stages 3+         |
 *
 * Power-of-2 optimized lengths (N = 2^k + 1):
 *   17-tap: delay=4,  buffer=16, 4 MACs (fastest)
 *   33-tap: delay=8,  buffer=32, 8 MACs (fast)
 *   65-tap: delay=16, buffer=64, 16 MACs
 *
 * DDC Delay Formula: delay = (N/2 + 1) / 2 where N = filter taps
 *
 * Power-of-2 delays enable branchless modulo:
 *   dly_idx = (dly_idx + 1) & (DELAY - 1);  // vs if(++dly_idx >= DELAY)
 *
 * Copyright (C) 2025-2026, Benjamin Vernoux <bvernoux@hydrasdr.com>
 *
 * SPDX-License-Identifier: MIT
 */

#ifndef FILTERS_OPT_H
#define FILTERS_OPT_H

#include <stdint.h>

/* ========================================================================
 * 47_OPT: Optimized 47-tap (delay=12, Remez equiripple)
 * ========================================================================
 * Taps: 47, Delay: 12 samples
 * Stopband rejection: 63.4 dB
 * Passband ripple: 0.0057 dB
 * Non-zero taps: 25 (MACs per output)
 * ======================================================================== */

#define HB_KERNEL_FLOAT_LEN_47_OPT 47
#define HB_KERNEL_INT16_LEN_47_OPT 47
#define HB_KERNEL_DELAY_47_OPT 12

static const float HB_KERNEL_FLOAT_47_OPT[HB_KERNEL_FLOAT_LEN_47_OPT] = {
	-0.0008321749f, +0.0000000000f, +0.0015093728f, +0.0000000000f, -0.0027969178f, +0.0000000000f, 
	+0.0047298364f, +0.0000000000f, -0.0075182993f, +0.0000000000f, +0.0114524848f, +0.0000000000f, 
	-0.0169780880f, +0.0000000000f, +0.0248902450f, +0.0000000000f, -0.0368605061f, +0.0000000000f, 
	+0.0572482767f, +0.0000000000f, -0.1021458662f, +0.0000000000f, +0.3169722234f, +0.5000000000f, 
	+0.3169722234f, +0.0000000000f, -0.1021458662f, +0.0000000000f, +0.0572482767f, +0.0000000000f, 
	-0.0368605061f, +0.0000000000f, +0.0248902450f, +0.0000000000f, -0.0169780880f, +0.0000000000f, 
	+0.0114524848f, +0.0000000000f, -0.0075182993f, +0.0000000000f, +0.0047298364f, +0.0000000000f, 
	-0.0027969178f, +0.0000000000f, +0.0015093728f, +0.0000000000f, -0.0008321749f
};

static const int16_t HB_KERNEL_INT16_47_OPT[HB_KERNEL_INT16_LEN_47_OPT] = {
	   -27,      0,     49,      0,    -92,      0,    155,      0,   -246,      0,    375,      0, 
	  -556,      0,    816,      0,  -1208,      0,   1876,      0,  -3347,      0,  10387,  16384, 
	 10387,      0,  -3347,      0,   1876,      0,  -1208,      0,    816,      0,   -556,      0, 
	   375,      0,   -246,      0,    155,      0,    -92,      0,     49,      0,    -27
};

/* ========================================================================
 * 65_POW2: Optimized 65-tap (power-of-2 delay=16)
 * ========================================================================
 * Taps: 65, Delay: 16 samples  (POWER OF 2)
 * Stopband rejection: 66.2 dB
 * Passband ripple: 0.0037 dB
 * Non-zero taps: 33 (MACs per output)
 * ======================================================================== */

#define HB_KERNEL_FLOAT_LEN_65_POW2 65
#define HB_KERNEL_INT16_LEN_65_POW2 65
#define HB_KERNEL_DELAY_65_POW2 16

static const float HB_KERNEL_FLOAT_65_POW2[HB_KERNEL_FLOAT_LEN_65_POW2] = {
	+0.0000000000f, -0.0004656166f, +0.0000000000f, +0.0007122901f, +0.0000000000f, -0.0012306393f, 
	+0.0000000000f, +0.0019719459f, +0.0000000000f, -0.0029951722f, +0.0000000000f, +0.0043708455f, 
	+0.0000000000f, -0.0061862988f, +0.0000000000f, +0.0085557929f, +0.0000000000f, -0.0116401081f, 
	+0.0000000000f, +0.0156855989f, +0.0000000000f, -0.0211074312f, +0.0000000000f, +0.0286853686f, 
	+0.0000000000f, -0.0400958509f, +0.0000000000f, +0.0597217381f, +0.0000000000f, -0.1036983567f, 
	+0.0000000000f, +0.3175013422f, +0.5000000000f, +0.3175013422f, +0.0000000000f, -0.1036983567f, 
	+0.0000000000f, +0.0597217381f, +0.0000000000f, -0.0400958509f, +0.0000000000f, +0.0286853686f, 
	+0.0000000000f, -0.0211074312f, +0.0000000000f, +0.0156855989f, +0.0000000000f, -0.0116401081f, 
	+0.0000000000f, +0.0085557929f, +0.0000000000f, -0.0061862988f, +0.0000000000f, +0.0043708455f, 
	+0.0000000000f, -0.0029951722f, +0.0000000000f, +0.0019719459f, +0.0000000000f, -0.0012306393f, 
	+0.0000000000f, +0.0007122901f, +0.0000000000f, -0.0004656166f, +0.0000000000f
};

static const int16_t HB_KERNEL_INT16_65_POW2[HB_KERNEL_INT16_LEN_65_POW2] = {
	     0,    -15,      0,     23,      0,    -40,      0,     65,      0,    -98,      0,    143, 
	     0,   -203,      0,    280,      0,   -381,      0,    514,      0,   -692,      0,    940, 
	     0,  -1314,      0,   1957,      0,  -3398,      0,  10404,  16384,  10404,      0,  -3398, 
	     0,   1957,      0,  -1314,      0,    940,      0,   -692,      0,    514,      0,   -381, 
	     0,    280,      0,   -203,      0,    143,      0,    -98,      0,     65,      0,    -40, 
	     0,     23,      0,    -15,      0
};

/* ========================================================================
 * 83_HIGHPERF: High-performance 83-tap (delay=21, >100dB)
 * ========================================================================
 * Taps: 83, Delay: 21 samples
 * Stopband rejection: 102.4 dB
 * Passband ripple: 0.0001 dB
 * Non-zero taps: 43 (MACs per output)
 * ======================================================================== */

#define HB_KERNEL_FLOAT_LEN_83_HIGHPERF 83
#define HB_KERNEL_INT16_LEN_83_HIGHPERF 83
#define HB_KERNEL_DELAY_83_HIGHPERF 21

static const float HB_KERNEL_FLOAT_83_HIGHPERF[HB_KERNEL_FLOAT_LEN_83_HIGHPERF] = {
	+0.0000143931f, +0.0000000000f, -0.0000396330f, +0.0000000000f, +0.0000913706f, +0.0000000000f, 
	-0.0001839242f, +0.0000000000f, +0.0003377073f, +0.0000000000f, -0.0005792069f, +0.0000000000f, 
	+0.0009416672f, +0.0000000000f, -0.0014659049f, +0.0000000000f, +0.0022012165f, +0.0000000000f, 
	-0.0032069485f, +0.0000000000f, +0.0045551629f, +0.0000000000f, -0.0063358222f, +0.0000000000f, 
	+0.0086665642f, +0.0000000000f, -0.0117119084f, +0.0000000000f, +0.0157218386f, +0.0000000000f, 
	-0.0211146700f, +0.0000000000f, +0.0286723034f, +0.0000000000f, -0.0400722031f, +0.0000000000f, 
	+0.0596968493f, +0.0000000000f, -0.1036799980f, +0.0000000000f, +0.3174946235f, +0.5000000000f, 
	+0.3174946235f, +0.0000000000f, -0.1036799980f, +0.0000000000f, +0.0596968493f, +0.0000000000f, 
	-0.0400722031f, +0.0000000000f, +0.0286723034f, +0.0000000000f, -0.0211146700f, +0.0000000000f, 
	+0.0157218386f, +0.0000000000f, -0.0117119084f, +0.0000000000f, +0.0086665642f, +0.0000000000f, 
	-0.0063358222f, +0.0000000000f, +0.0045551629f, +0.0000000000f, -0.0032069485f, +0.0000000000f, 
	+0.0022012165f, +0.0000000000f, -0.0014659049f, +0.0000000000f, +0.0009416672f, +0.0000000000f, 
	-0.0005792069f, +0.0000000000f, +0.0003377073f, +0.0000000000f, -0.0001839242f, +0.0000000000f, 
	+0.0000913706f, +0.0000000000f, -0.0000396330f, +0.0000000000f, +0.0000143931f
};

static const int16_t HB_KERNEL_INT16_83_HIGHPERF[HB_KERNEL_INT16_LEN_83_HIGHPERF] = {
	     0,      0,     -1,      0,      3,      0,     -6,      0,     11,      0,    -19,      0, 
	    31,      0,    -48,      0,     72,      0,   -105,      0,    149,      0,   -208,      0, 
	   284,      0,   -384,      0,    515,      0,   -692,      0,    940,      0,  -1313,      0, 
	  1956,      0,  -3397,      0,  10404,  16384,  10404,      0,  -3397,      0,   1956,      0, 
	 -1313,      0,    940,      0,   -692,      0,    515,      0,   -384,      0,    284,      0, 
	  -208,      0,    149,      0,   -105,      0,     72,      0,    -48,      0,     31,      0, 
	   -19,      0,     11,      0,     -6,      0,      3,      0,     -1,      0,      0
};

/* ========================================================================
 * 33_FAST: Optimized 33-tap (power-of-2 delay=8, ~62dB, stages 0-2)
 * ========================================================================
 * Taps: 33, Delay: 8 samples  (POWER OF 2)
 * Stopband rejection: 61.7 dB
 * Passband ripple: 0.0068 dB
 * Non-zero taps: 17 (MACs per output)
 * ======================================================================== */

#define HB_KERNEL_FLOAT_LEN_33_FAST 33
#define HB_KERNEL_INT16_LEN_33_FAST 33
#define HB_KERNEL_DELAY_33_FAST 8

static const float HB_KERNEL_FLOAT_33_FAST[HB_KERNEL_FLOAT_LEN_33_FAST] = {
	+0.0000000000f, -0.0014766307f, +0.0000000000f, +0.0037777218f, +0.0000000000f, -0.0082232170f, 
	+0.0000000000f, +0.0157831325f, +0.0000000000f, -0.0283219394f, +0.0000000000f, +0.0502512662f, 
	+0.0000000000f, -0.0975510368f, +0.0000000000f, +0.3153703712f, +0.5000000000f, +0.3153703712f, 
	+0.0000000000f, -0.0975510368f, +0.0000000000f, +0.0502512662f, +0.0000000000f, -0.0283219394f, 
	+0.0000000000f, +0.0157831325f, +0.0000000000f, -0.0082232170f, +0.0000000000f, +0.0037777218f, 
	+0.0000000000f, -0.0014766307f, +0.0000000000f
};

static const int16_t HB_KERNEL_INT16_33_FAST[HB_KERNEL_INT16_LEN_33_FAST] = {
	     0,    -48,      0,    124,      0,   -269,      0,    517,      0,   -928,      0,   1647, 
	     0,  -3197,      0,  10334,  16384,  10334,      0,  -3197,      0,   1647,      0,   -928, 
	     0,    517,      0,   -269,      0,    124,      0,    -48,      0
};

/* ========================================================================
 * 17_FAST: Low-ripple 17-tap (power-of-2 delay=4, ~59dB, stages 3+)
 * ========================================================================
 * Taps: 17, Delay: 4 samples  (POWER OF 2)
 * Stopband rejection: 58.8 dB
 * Passband ripple: 0.0098 dB
 * Non-zero taps: 9 (MACs per output)
 * ======================================================================== */

#define HB_KERNEL_FLOAT_LEN_17_FAST 17
#define HB_KERNEL_INT16_LEN_17_FAST 17
#define HB_KERNEL_DELAY_17_FAST 4

static const float HB_KERNEL_FLOAT_17_FAST[HB_KERNEL_FLOAT_LEN_17_FAST] = {
	+0.0000000000f, -0.0060093832f, +0.0000000000f, +0.0253702022f, +0.0000000000f, -0.0776522120f, 
	+0.0000000000f, +0.3077303492f, +0.5000000000f, +0.3077303492f, +0.0000000000f, -0.0776522120f, 
	+0.0000000000f, +0.0253702022f, +0.0000000000f, -0.0060093832f, +0.0000000000f
};

static const int16_t HB_KERNEL_INT16_17_FAST[HB_KERNEL_INT16_LEN_17_FAST] = {
	     0,   -197,      0,    831,      0,  -2545,      0,  10084,  16384,  10084,      0,  -2545, 
	     0,    831,      0,   -197,      0
};

/* ========================================================================
 * DEFAULT CONFIGURATION
 * ========================================================================
 * Set HB_KERNEL_CONFIG to select default filter:
 *   0 = 47_OPT (optimized 47-tap, Remez equiripple) - DEFAULT
 *   1 = 65_POW2 (power-of-2 delay, branchless)
 *   2 = 83_HIGHPERF (high dynamic range)
 *   3 = 33_FAST (fast 33-tap, 8 MACs, ~62dB)
 *   4 = 17_FAST (low-ripple 17-tap, 4 MACs, ~59dB)
 * ======================================================================== */

#ifndef HB_KERNEL_CONFIG
#define HB_KERNEL_CONFIG 0  /* Default: 47_OPT (optimized 47-tap) */
#endif

#undef HB_KERNEL_FLOAT
#undef HB_KERNEL_INT16
#undef HB_KERNEL_FLOAT_LEN
#undef HB_KERNEL_INT16_LEN
#undef HB_KERNEL_DELAY

#if HB_KERNEL_CONFIG == 0
    #define HB_KERNEL_FLOAT     HB_KERNEL_FLOAT_47_OPT
    #define HB_KERNEL_INT16     HB_KERNEL_INT16_47_OPT
    #define HB_KERNEL_FLOAT_LEN HB_KERNEL_FLOAT_LEN_47_OPT
    #define HB_KERNEL_INT16_LEN HB_KERNEL_INT16_LEN_47_OPT
    #define HB_KERNEL_DELAY     HB_KERNEL_DELAY_47_OPT
#elif HB_KERNEL_CONFIG == 1
    #define HB_KERNEL_FLOAT     HB_KERNEL_FLOAT_65_POW2
    #define HB_KERNEL_INT16     HB_KERNEL_INT16_65_POW2
    #define HB_KERNEL_FLOAT_LEN HB_KERNEL_FLOAT_LEN_65_POW2
    #define HB_KERNEL_INT16_LEN HB_KERNEL_INT16_LEN_65_POW2
    #define HB_KERNEL_DELAY     HB_KERNEL_DELAY_65_POW2
#elif HB_KERNEL_CONFIG == 2
    #define HB_KERNEL_FLOAT     HB_KERNEL_FLOAT_83_HIGHPERF
    #define HB_KERNEL_INT16     HB_KERNEL_INT16_83_HIGHPERF
    #define HB_KERNEL_FLOAT_LEN HB_KERNEL_FLOAT_LEN_83_HIGHPERF
    #define HB_KERNEL_INT16_LEN HB_KERNEL_INT16_LEN_83_HIGHPERF
    #define HB_KERNEL_DELAY     HB_KERNEL_DELAY_83_HIGHPERF
#elif HB_KERNEL_CONFIG == 3
    #define HB_KERNEL_FLOAT     HB_KERNEL_FLOAT_33_FAST
    #define HB_KERNEL_INT16     HB_KERNEL_INT16_33_FAST
    #define HB_KERNEL_FLOAT_LEN HB_KERNEL_FLOAT_LEN_33_FAST
    #define HB_KERNEL_INT16_LEN HB_KERNEL_INT16_LEN_33_FAST
    #define HB_KERNEL_DELAY     HB_KERNEL_DELAY_33_FAST
#elif HB_KERNEL_CONFIG == 4
    #define HB_KERNEL_FLOAT     HB_KERNEL_FLOAT_17_FAST
    #define HB_KERNEL_INT16     HB_KERNEL_INT16_17_FAST
    #define HB_KERNEL_FLOAT_LEN HB_KERNEL_FLOAT_LEN_17_FAST
    #define HB_KERNEL_INT16_LEN HB_KERNEL_INT16_LEN_17_FAST
    #define HB_KERNEL_DELAY     HB_KERNEL_DELAY_17_FAST
#else
    #error "Invalid HB_KERNEL_CONFIG value (0=47_OPT, 1=65_POW2, 2=83_HIGHPERF, 3=33_FAST, 4=17_FAST)"
#endif

/*
 * USAGE NOTES
 * ===========
 *
 * 1. SELECTING A FILTER:
 *    Before including this header, define HB_KERNEL_CONFIG:
 *      #define HB_KERNEL_CONFIG 3  // Use 33_FAST
 *      #include "filters_opt.h"
 *
 * 2. DIRECT ACCESS:
 *    Use specific filter directly:
 *      iqconverter_create(HB_KERNEL_FLOAT_33_FAST, HB_KERNEL_FLOAT_LEN_33_FAST, "float32_opt");
 *
 * 3. POWER-OF-2 DELAY OPTIMIZATION:
 *    For 17_FAST (delay=4), 33_FAST (delay=8), or 65_POW2 (delay=16):
 *      dly_idx = (dly_idx + 1) & (HB_KERNEL_DELAY - 1);  // Branchless wrap
 *
 *    For 47_OPT (delay=12) or 83_HIGHPERF (delay=21):
 *      if (++dly_idx >= HB_KERNEL_DELAY) dly_idx = 0;    // Branch required
 *
 * 4. FIR TAP COUNT (Symmetric FIR uses N_nonzero/2 MACs):
 *      17_FAST:     4 MACs (9 non-zero / 2)   - decimation stages 3+
 *      33_FAST:     8 MACs (17 non-zero / 2)  - decimation stages 0-2
 *      47_OPT:     12 MACs (25 non-zero / 2)  - default base DDC
 *      65_POW2:    16 MACs (33 non-zero / 2)
 *      83_HIGHPERF: 21 MACs (43 non-zero / 2)
 *
 * 5. CASCADED DECIMATION (< 0.1 dB total ripple at 64x):
 *      Stages 0-2: 33_FAST (pb=0.195, 0.0137 dB ripple, 62 dB rejection)
 *      Stages 3-5: 17_FAST (pb=0.148, 0.0192 dB ripple, 59 dB rejection)
 *      64x cascade: 3x0.0137 + 3x0.0192 = 0.083 dB total (< 0.1 dB target)
 */

#endif /* FILTERS_OPT_H */
