---
id: learning-resources
title: 📚 Learning Resources
description: >-
  Interactive learning platforms and community resources to help you learn Fiber concepts through hands-on practice.
sidebar_position: 3
---

## Interactive Learning Platforms

Looking to practice Fiber concepts through hands-on exercises? Here are some community-driven learning resources:

### Go Interview Practice - Fiber Challenges

A comprehensive platform offering progressive Fiber challenges that complement the official documentation.

![Learning Path Overview](/img/learning-resources/fiber-learning-path.png)

**What You'll Learn:**

- **High-Performance APIs** - Build ultra-fast RESTful APIs with zero-allocation routing
- **Middleware & Security** - Implement custom middleware, rate limiting, CORS, and authentication
- **Request Validation** - Input validation, error handling, and data transformation
- **Authentication & JWT** - Secure authentication systems with JWT tokens and API key validation

![Challenge Interface](/img/learning-resources/fiber-challenge-interface.png)

**Challenge Roadmap:**

1. **Basic Routing** - Setup Fiber, routes, and handlers (Beginner)
2. **Middleware & CORS** - Custom middleware and rate limiting (Intermediate)
3. **Validation & Errors** - Input validation and error handling (Intermediate)
4. **Authentication** - JWT tokens and API key validation (Advanced)

![Fiber Framework Overview](/img/learning-resources/fiber-framework-overview.png)

![Interactive Learning Experience](/img/learning-resources/fiber-learning-experience.png)

[Explore Fiber Challenges →](https://rezasi.github.io/go-interview-practice/fiber) | [GitHub Repository →](https://github.com/RezaSi/go-interview-practice)
