//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

import "time"

// CommonResourceProperties - Resource properties.
type CommonResourceProperties struct {
	// READ-ONLY; Resource ID
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type. Example: "Microsoft.Quota/quotas"
	Type *string
}

// CreateGenericQuotaRequestParameters - Quota change requests information.
type CreateGenericQuotaRequestParameters struct {
	// Quota change requests.
	Value []*CurrentQuotaLimitBase
}

// CurrentQuotaLimitBase - Quota limit.
type CurrentQuotaLimitBase struct {
	// Quota properties for the specified resource, based on the API called, Quotas or Usages.
	Properties *Properties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// CurrentUsagesBase - Resource usage.
type CurrentUsagesBase struct {
	// Usage properties for the specified resource.
	Properties *UsagesProperties

	// READ-ONLY; The resource ID.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; The resource type.
	Type *string
}

// ExceptionResponse - Error.
type ExceptionResponse struct {
	// API error details.
	Error *ServiceError
}

// LimitJSONObject - LimitJson abstract class.
type LimitJSONObject struct {
	// REQUIRED; The limit object type.
	LimitObjectType *LimitType
}

// GetLimitJSONObject implements the LimitJSONObjectClassification interface for type LimitJSONObject.
func (l *LimitJSONObject) GetLimitJSONObject() *LimitJSONObject { return l }

// LimitObject - The resource quota limit value.
type LimitObject struct {
	// REQUIRED; The limit object type.
	LimitObjectType *LimitType

	// REQUIRED; The quota/limit value
	Value *int32

	// The quota or usages limit types.
	LimitType *QuotaLimitTypes
}

// GetLimitJSONObject implements the LimitJSONObjectClassification interface for type LimitObject.
func (l *LimitObject) GetLimitJSONObject() *LimitJSONObject {
	return &LimitJSONObject{
		LimitObjectType: l.LimitObjectType,
	}
}

// Limits - Quota limits.
type Limits struct {
	// The URI used to fetch the next page of quota limits. When there are no more pages, this string is null.
	NextLink *string

	// List of quota limits.
	Value []*CurrentQuotaLimitBase
}

// LimitsResponse - Quota limits request response.
type LimitsResponse struct {
	// The URI used to fetch the next page of quota limits. When there are no more pages, this is null.
	NextLink *string

	// List of quota limits with the quota request status.
	Value []*CurrentQuotaLimitBase
}

type OperationDisplay struct {
	// Operation description.
	Description *string

	// Operation name.
	Operation *string

	// Provider name.
	Provider *string

	// Resource name.
	Resource *string
}

type OperationList struct {
	// URL to get the next page of items.
	NextLink *string
	Value    []*OperationResponse
}

type OperationResponse struct {
	Display *OperationDisplay
	Name    *string
	Origin  *string
}

// Properties - Quota properties for the specified resource.
type Properties struct {
	// Resource quota limit properties.
	Limit LimitJSONObjectClassification

	// Resource name provided by the resource provider. Use this property name when requesting quota.
	Name *ResourceName

	// Additional properties for the specific resource provider.
	Properties any

	// The name of the resource type. Optional field.
	ResourceType *string

	// READ-ONLY; States if quota can be requested for this resource.
	IsQuotaApplicable *bool

	// READ-ONLY; The time period over which the quota usage values are summarized. For example: *P1D (per one day) *PT1M (per
	// one minute) *PT1S (per one second). This parameter is optional because, for some resources
	// like compute, the period is irrelevant.
	QuotaPeriod *string

	// READ-ONLY; The quota units, such as Count and Bytes. When requesting quota, use the unit value returned in the GET response
	// in the request body of your PUT operation.
	Unit *string
}

// RequestDetails - List of quota requests with details.
type RequestDetails struct {
	// Quota request details.
	Properties *RequestProperties

	// READ-ONLY; Quota request ID.
	ID *string

	// READ-ONLY; Quota request name.
	Name *string

	// READ-ONLY; Resource type. "Microsoft.Quota/quotas".
	Type *string
}

// RequestDetailsList - Quota request information.
type RequestDetailsList struct {
	// The URI for fetching the next page of quota limits. When there are no more pages, this string is null.
	NextLink *string

	// Quota request details.
	Value []*RequestDetails
}

// RequestOneResourceProperties - Quota request.
type RequestOneResourceProperties struct {
	// Error details of the quota request.
	Error *ServiceErrorDetail

	// Resource quota limit properties.
	Limit *LimitObject

	// Resource name provided by the resource provider. Use this property name when requesting quota.
	Name *ResourceName

	// Additional properties for the specific resource provider.
	Properties any

	// The name of the resource type. Optional field.
	ResourceType *string

	// The quota limit units, such as Count and Bytes. When requesting quota, use the unit value returned in the GET response
	// in the request body of your PUT operation.
	Unit *string

	// READ-ONLY; Usage information for the current resource.
	CurrentValue *int32

	// READ-ONLY; States if quota can be requested for this resource.
	IsQuotaApplicable *bool

	// READ-ONLY; User-friendly status message.
	Message *string

	// READ-ONLY; Quota request status.
	ProvisioningState *QuotaRequestState

	// READ-ONLY; The time period over which the quota usage values are summarized. For example: *P1D (per one day) *PT1M (per
	// one minute) *PT1S (per one second). This parameter is optional because, for some resources
	// like compute, the period is irrelevant.
	QuotaPeriod *string

	// READ-ONLY; Quota request submission time. The date conforms to the following ISO 8601 standard format: yyyy-MM-ddTHH:mm:ssZ.
	RequestSubmitTime *time.Time
}

// RequestOneResourceSubmitResponse - Quota request response.
type RequestOneResourceSubmitResponse struct {
	// Quota request details.
	Properties *RequestOneResourceProperties

	// READ-ONLY; Quota request ID.
	ID *string

	// READ-ONLY; The name of the quota request.
	Name *string

	// READ-ONLY; Resource type. "Microsoft.Quota/ServiceLimitRequests"
	Type *string
}

// RequestProperties - Quota request properties.
type RequestProperties struct {
	// Error details of the quota request.
	Error *ServiceErrorDetail

	// Quota request details.
	Value []*SubRequest

	// READ-ONLY; User-friendly status message.
	Message *string

	// READ-ONLY; The quota request status.
	ProvisioningState *QuotaRequestState

	// READ-ONLY; The quota request submission time. The date conforms to the following format specified by the ISO 8601 standard:
	// yyyy-MM-ddTHH:mm:ssZ
	RequestSubmitTime *time.Time
}

// RequestStatusDetails - Quota request status details.
type RequestStatusDetails struct {
	// Resource quota limit properties.
	Limit *LimitObject

	// Resource name provided by the resource provider. Use this property name when requesting quota.
	Name *ResourceName

	// Additional properties for the specific resource provider.
	Properties any

	// The name of the resource type. Optional field.
	ResourceType *string

	// The quota limit units, such as Count and Bytes. When requesting quota, use the unit value returned in the GET response
	// in the request body of your PUT operation.
	Unit *string

	// READ-ONLY; User-friendly message.
	Message *string

	// READ-ONLY; Quota request status.
	ProvisioningState *QuotaRequestState

	// READ-ONLY; The time period over which the quota usage values are summarized. For example: *P1D (per one day) *PT1M (per
	// one minute) *PT1S (per one second). This parameter is optional because, for some resources
	// like compute, the period is irrelevant.
	QuotaPeriod *string
}

// RequestSubmitResponse - Quota request response.
type RequestSubmitResponse struct {
	// Quota request details.
	Properties *RequestProperties

	// READ-ONLY; Quota request ID.
	ID *string

	// READ-ONLY; Quota request name.
	Name *string

	// READ-ONLY; Resource type. "Microsoft.Quota/quotas".
	Type *string
}

// RequestSubmitResponse202 - The quota request response with the quota request ID.
type RequestSubmitResponse202 struct {
	// Quota request status.
	Properties *RequestStatusDetails

	// READ-ONLY; The quota request ID. To check the request status, use the id value in a Quota Request Status [https://docs.microsoft.com/en-us/rest/api/reserved-vm-instances/quotarequeststatus/get]
	// GET operation.
	ID *string

	// READ-ONLY; Operation ID.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceName - Name of the resource provided by the resource Provider. When requesting quota, use this property name.
type ResourceName struct {
	// Resource name.
	Value *string

	// READ-ONLY; Resource display name.
	LocalizedValue *string
}

// ServiceError - API error details.
type ServiceError struct {
	// Error code.
	Code *string

	// Error message.
	Message *string

	// READ-ONLY; List of error details.
	Details []*ServiceErrorDetail
}

// ServiceErrorDetail - Error details.
type ServiceErrorDetail struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message.
	Message *string
}

// SubRequest - Request property.
type SubRequest struct {
	// Resource quota limit properties.
	Limit LimitJSONObjectClassification

	// Resource name.
	Name *ResourceName

	// Quota limit units, such as Count and Bytes. When requesting quota, use the unit value returned in the GET response in the
	// request body of your PUT operation.
	Unit *string

	// READ-ONLY; User-friendly status message.
	Message *string

	// READ-ONLY; The quota request status.
	ProvisioningState *QuotaRequestState

	// READ-ONLY; Resource type for which the quota properties were requested.
	ResourceType *string

	// READ-ONLY; Quota request ID.
	SubRequestID *string
}

// UsagesLimits - Quota limits.
type UsagesLimits struct {
	// The URI used to fetch the next page of quota limits. When there are no more pages, this is null.
	NextLink *string

	// List of quota limits.
	Value []*CurrentUsagesBase
}

// UsagesObject - The resource usages value.
type UsagesObject struct {
	// REQUIRED; The usages value.
	Value *int32

	// The quota or usages limit types.
	UsagesType *UsagesTypes
}

// UsagesProperties - Usage properties for the specified resource.
type UsagesProperties struct {
	// Resource name provided by the resource provider. Use this property name when requesting quota.
	Name *ResourceName

	// Additional properties for the specific resource provider.
	Properties any

	// The name of the resource type. Optional field.
	ResourceType *string

	// The quota limit properties for this resource.
	Usages *UsagesObject

	// READ-ONLY; States if quota can be requested for this resource.
	IsQuotaApplicable *bool

	// READ-ONLY; The time period for the summary of the quota usage values. For example: *P1D (per one day) *PT1M (per one minute)
	// *PT1S (per one second). This parameter is optional because it is not relevant for all
	// resources such as compute.
	QuotaPeriod *string

	// READ-ONLY; The units for the quota usage, such as Count and Bytes. When requesting quota, use the unit value returned in
	// the GET response in the request body of your PUT operation.
	Unit *string
}
