//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managementpartner/armmanagementpartner"
	"net/http"
	"net/url"
	"regexp"
)

// PartnerServer is a fake server for instances of the armmanagementpartner.PartnerClient type.
type PartnerServer struct {
	// Create is the fake for method PartnerClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, partnerID string, options *armmanagementpartner.PartnerClientCreateOptions) (resp azfake.Responder[armmanagementpartner.PartnerClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method PartnerClient.Delete
	// HTTP status codes to indicate success: http.StatusOK
	Delete func(ctx context.Context, partnerID string, options *armmanagementpartner.PartnerClientDeleteOptions) (resp azfake.Responder[armmanagementpartner.PartnerClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PartnerClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, partnerID string, options *armmanagementpartner.PartnerClientGetOptions) (resp azfake.Responder[armmanagementpartner.PartnerClientGetResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method PartnerClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, partnerID string, options *armmanagementpartner.PartnerClientUpdateOptions) (resp azfake.Responder[armmanagementpartner.PartnerClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewPartnerServerTransport creates a new instance of PartnerServerTransport with the provided implementation.
// The returned PartnerServerTransport instance is connected to an instance of armmanagementpartner.PartnerClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPartnerServerTransport(srv *PartnerServer) *PartnerServerTransport {
	return &PartnerServerTransport{srv: srv}
}

// PartnerServerTransport connects instances of armmanagementpartner.PartnerClient to instances of PartnerServer.
// Don't use this type directly, use NewPartnerServerTransport instead.
type PartnerServerTransport struct {
	srv *PartnerServer
}

// Do implements the policy.Transporter interface for PartnerServerTransport.
func (p *PartnerServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PartnerClient.Create":
		resp, err = p.dispatchCreate(req)
	case "PartnerClient.Delete":
		resp, err = p.dispatchDelete(req)
	case "PartnerClient.Get":
		resp, err = p.dispatchGet(req)
	case "PartnerClient.Update":
		resp, err = p.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PartnerServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if p.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ManagementPartner/partners/(?P<partnerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	partnerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Create(req.Context(), partnerIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PartnerResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PartnerServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if p.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ManagementPartner/partners/(?P<partnerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	partnerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Delete(req.Context(), partnerIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PartnerServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ManagementPartner/partners/(?P<partnerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	partnerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), partnerIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PartnerResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PartnerServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/providers/Microsoft\.ManagementPartner/partners/(?P<partnerId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	partnerIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Update(req.Context(), partnerIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PartnerResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
