//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/consumption/armconsumption"
	"net/http"
	"net/url"
	"regexp"
)

// ReservationTransactionsServer is a fake server for instances of the armconsumption.ReservationTransactionsClient type.
type ReservationTransactionsServer struct {
	// NewListPager is the fake for method ReservationTransactionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(billingAccountID string, options *armconsumption.ReservationTransactionsClientListOptions) (resp azfake.PagerResponder[armconsumption.ReservationTransactionsClientListResponse])

	// NewListByBillingProfilePager is the fake for method ReservationTransactionsClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountID string, billingProfileID string, options *armconsumption.ReservationTransactionsClientListByBillingProfileOptions) (resp azfake.PagerResponder[armconsumption.ReservationTransactionsClientListByBillingProfileResponse])
}

// NewReservationTransactionsServerTransport creates a new instance of ReservationTransactionsServerTransport with the provided implementation.
// The returned ReservationTransactionsServerTransport instance is connected to an instance of armconsumption.ReservationTransactionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReservationTransactionsServerTransport(srv *ReservationTransactionsServer) *ReservationTransactionsServerTransport {
	return &ReservationTransactionsServerTransport{
		srv:                          srv,
		newListPager:                 newTracker[azfake.PagerResponder[armconsumption.ReservationTransactionsClientListResponse]](),
		newListByBillingProfilePager: newTracker[azfake.PagerResponder[armconsumption.ReservationTransactionsClientListByBillingProfileResponse]](),
	}
}

// ReservationTransactionsServerTransport connects instances of armconsumption.ReservationTransactionsClient to instances of ReservationTransactionsServer.
// Don't use this type directly, use NewReservationTransactionsServerTransport instead.
type ReservationTransactionsServerTransport struct {
	srv                          *ReservationTransactionsServer
	newListPager                 *tracker[azfake.PagerResponder[armconsumption.ReservationTransactionsClientListResponse]]
	newListByBillingProfilePager *tracker[azfake.PagerResponder[armconsumption.ReservationTransactionsClientListByBillingProfileResponse]]
}

// Do implements the policy.Transporter interface for ReservationTransactionsServerTransport.
func (r *ReservationTransactionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReservationTransactionsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ReservationTransactionsClient.NewListByBillingProfilePager":
		resp, err = r.dispatchNewListByBillingProfilePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReservationTransactionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/reservationTransactions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		billingAccountIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountId")])
		if err != nil {
			return nil, err
		}
		var options *armconsumption.ReservationTransactionsClientListOptions
		if filterParam != nil {
			options = &armconsumption.ReservationTransactionsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := r.srv.NewListPager(billingAccountIDParam, options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armconsumption.ReservationTransactionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ReservationTransactionsServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := r.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Consumption/reservationTransactions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		billingAccountIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountId")])
		if err != nil {
			return nil, err
		}
		billingProfileIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileId")])
		if err != nil {
			return nil, err
		}
		var options *armconsumption.ReservationTransactionsClientListByBillingProfileOptions
		if filterParam != nil {
			options = &armconsumption.ReservationTransactionsClientListByBillingProfileOptions{
				Filter: filterParam,
			}
		}
		resp := r.srv.NewListByBillingProfilePager(billingAccountIDParam, billingProfileIDParam, options)
		newListByBillingProfilePager = &resp
		r.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armconsumption.ReservationTransactionsClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		r.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}
