//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcommunication

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SuppressionListsClient contains the methods for the SuppressionLists group.
// Don't use this type directly, use NewSuppressionListsClient() instead.
type SuppressionListsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSuppressionListsClient creates a new instance of SuppressionListsClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSuppressionListsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SuppressionListsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SuppressionListsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Add a new SuppressionList resource under the parent Domains resource or update an existing SuppressionList
// resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - emailServiceName - The name of the EmailService resource.
//   - domainName - The name of the Domains resource.
//   - suppressionListName - The name of the suppression list.
//   - parameters - Parameters for the create or update operation
//   - options - SuppressionListsClientCreateOrUpdateOptions contains the optional parameters for the SuppressionListsClient.CreateOrUpdate
//     method.
func (client *SuppressionListsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, parameters SuppressionListResource, options *SuppressionListsClientCreateOrUpdateOptions) (SuppressionListsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "SuppressionListsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, emailServiceName, domainName, suppressionListName, parameters, options)
	if err != nil {
		return SuppressionListsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SuppressionListsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return SuppressionListsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *SuppressionListsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, parameters SuppressionListResource, options *SuppressionListsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if emailServiceName == "" {
		return nil, errors.New("parameter emailServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailServiceName}", url.PathEscape(emailServiceName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if suppressionListName == "" {
		return nil, errors.New("parameter suppressionListName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{suppressionListName}", url.PathEscape(suppressionListName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *SuppressionListsClient) createOrUpdateHandleResponse(resp *http.Response) (SuppressionListsClientCreateOrUpdateResponse, error) {
	result := SuppressionListsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SuppressionListResource); err != nil {
		return SuppressionListsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete a SuppressionList.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - emailServiceName - The name of the EmailService resource.
//   - domainName - The name of the Domains resource.
//   - suppressionListName - The name of the suppression list.
//   - options - SuppressionListsClientDeleteOptions contains the optional parameters for the SuppressionListsClient.Delete method.
func (client *SuppressionListsClient) Delete(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, options *SuppressionListsClientDeleteOptions) (SuppressionListsClientDeleteResponse, error) {
	var err error
	const operationName = "SuppressionListsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, emailServiceName, domainName, suppressionListName, options)
	if err != nil {
		return SuppressionListsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SuppressionListsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return SuppressionListsClientDeleteResponse{}, err
	}
	return SuppressionListsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SuppressionListsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, options *SuppressionListsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if emailServiceName == "" {
		return nil, errors.New("parameter emailServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailServiceName}", url.PathEscape(emailServiceName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if suppressionListName == "" {
		return nil, errors.New("parameter suppressionListName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{suppressionListName}", url.PathEscape(suppressionListName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a SuppressionList resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - emailServiceName - The name of the EmailService resource.
//   - domainName - The name of the Domains resource.
//   - suppressionListName - The name of the suppression list.
//   - options - SuppressionListsClientGetOptions contains the optional parameters for the SuppressionListsClient.Get method.
func (client *SuppressionListsClient) Get(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, options *SuppressionListsClientGetOptions) (SuppressionListsClientGetResponse, error) {
	var err error
	const operationName = "SuppressionListsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, emailServiceName, domainName, suppressionListName, options)
	if err != nil {
		return SuppressionListsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SuppressionListsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SuppressionListsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SuppressionListsClient) getCreateRequest(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, options *SuppressionListsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if emailServiceName == "" {
		return nil, errors.New("parameter emailServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailServiceName}", url.PathEscape(emailServiceName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if suppressionListName == "" {
		return nil, errors.New("parameter suppressionListName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{suppressionListName}", url.PathEscape(suppressionListName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SuppressionListsClient) getHandleResponse(resp *http.Response) (SuppressionListsClientGetResponse, error) {
	result := SuppressionListsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SuppressionListResource); err != nil {
		return SuppressionListsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByDomainPager - List all suppression lists for a domains resource.
//
// Generated from API version 2023-06-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - emailServiceName - The name of the EmailService resource.
//   - domainName - The name of the Domains resource.
//   - options - SuppressionListsClientListByDomainOptions contains the optional parameters for the SuppressionListsClient.NewListByDomainPager
//     method.
func (client *SuppressionListsClient) NewListByDomainPager(resourceGroupName string, emailServiceName string, domainName string, options *SuppressionListsClientListByDomainOptions) *runtime.Pager[SuppressionListsClientListByDomainResponse] {
	return runtime.NewPager(runtime.PagingHandler[SuppressionListsClientListByDomainResponse]{
		More: func(page SuppressionListsClientListByDomainResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SuppressionListsClientListByDomainResponse) (SuppressionListsClientListByDomainResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SuppressionListsClient.NewListByDomainPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByDomainCreateRequest(ctx, resourceGroupName, emailServiceName, domainName, options)
			}, nil)
			if err != nil {
				return SuppressionListsClientListByDomainResponse{}, err
			}
			return client.listByDomainHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByDomainCreateRequest creates the ListByDomain request.
func (client *SuppressionListsClient) listByDomainCreateRequest(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, options *SuppressionListsClientListByDomainOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if emailServiceName == "" {
		return nil, errors.New("parameter emailServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailServiceName}", url.PathEscape(emailServiceName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByDomainHandleResponse handles the ListByDomain response.
func (client *SuppressionListsClient) listByDomainHandleResponse(resp *http.Response) (SuppressionListsClientListByDomainResponse, error) {
	result := SuppressionListsClientListByDomainResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SuppressionListResourceCollection); err != nil {
		return SuppressionListsClientListByDomainResponse{}, err
	}
	return result, nil
}
