//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazurestackhci

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VirtualHardDisksClient contains the methods for the VirtualHardDisks group.
// Don't use this type directly, use NewVirtualHardDisksClient() instead.
type VirtualHardDisksClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVirtualHardDisksClient creates a new instance of VirtualHardDisksClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVirtualHardDisksClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VirtualHardDisksClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VirtualHardDisksClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - The operation to create or update a virtual hard disk. Please note some properties can be set only
// during virtual hard disk creation.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - virtualHardDiskName - Name of the virtual hard disk
//   - options - VirtualHardDisksClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualHardDisksClient.BeginCreateOrUpdate
//     method.
func (client *VirtualHardDisksClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, virtualHardDiskName string, virtualHardDisks VirtualHardDisks, options *VirtualHardDisksClientBeginCreateOrUpdateOptions) (*runtime.Poller[VirtualHardDisksClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, virtualHardDiskName, virtualHardDisks, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[VirtualHardDisksClientCreateOrUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[VirtualHardDisksClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - The operation to create or update a virtual hard disk. Please note some properties can be set only during
// virtual hard disk creation.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
func (client *VirtualHardDisksClient) createOrUpdate(ctx context.Context, resourceGroupName string, virtualHardDiskName string, virtualHardDisks VirtualHardDisks, options *VirtualHardDisksClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "VirtualHardDisksClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, virtualHardDiskName, virtualHardDisks, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VirtualHardDisksClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, virtualHardDiskName string, virtualHardDisks VirtualHardDisks, options *VirtualHardDisksClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualHardDisks/{virtualHardDiskName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if virtualHardDiskName == "" {
		return nil, errors.New("parameter virtualHardDiskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{virtualHardDiskName}", url.PathEscape(virtualHardDiskName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, virtualHardDisks); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - The operation to delete a virtual hard disk.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - virtualHardDiskName - Name of the virtual hard disk
//   - options - VirtualHardDisksClientBeginDeleteOptions contains the optional parameters for the VirtualHardDisksClient.BeginDelete
//     method.
func (client *VirtualHardDisksClient) BeginDelete(ctx context.Context, resourceGroupName string, virtualHardDiskName string, options *VirtualHardDisksClientBeginDeleteOptions) (*runtime.Poller[VirtualHardDisksClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, virtualHardDiskName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[VirtualHardDisksClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[VirtualHardDisksClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - The operation to delete a virtual hard disk.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
func (client *VirtualHardDisksClient) deleteOperation(ctx context.Context, resourceGroupName string, virtualHardDiskName string, options *VirtualHardDisksClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "VirtualHardDisksClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, virtualHardDiskName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *VirtualHardDisksClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, virtualHardDiskName string, options *VirtualHardDisksClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualHardDisks/{virtualHardDiskName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if virtualHardDiskName == "" {
		return nil, errors.New("parameter virtualHardDiskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{virtualHardDiskName}", url.PathEscape(virtualHardDiskName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets a virtual hard disk
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - virtualHardDiskName - Name of the virtual hard disk
//   - options - VirtualHardDisksClientGetOptions contains the optional parameters for the VirtualHardDisksClient.Get method.
func (client *VirtualHardDisksClient) Get(ctx context.Context, resourceGroupName string, virtualHardDiskName string, options *VirtualHardDisksClientGetOptions) (VirtualHardDisksClientGetResponse, error) {
	var err error
	const operationName = "VirtualHardDisksClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, virtualHardDiskName, options)
	if err != nil {
		return VirtualHardDisksClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VirtualHardDisksClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VirtualHardDisksClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VirtualHardDisksClient) getCreateRequest(ctx context.Context, resourceGroupName string, virtualHardDiskName string, options *VirtualHardDisksClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualHardDisks/{virtualHardDiskName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if virtualHardDiskName == "" {
		return nil, errors.New("parameter virtualHardDiskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{virtualHardDiskName}", url.PathEscape(virtualHardDiskName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VirtualHardDisksClient) getHandleResponse(resp *http.Response) (VirtualHardDisksClientGetResponse, error) {
	result := VirtualHardDisksClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VirtualHardDisks); err != nil {
		return VirtualHardDisksClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Lists all of the virtual hard disks in the specified resource group. Use the nextLink property in the response
// to get the next page of virtual hard disks.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - VirtualHardDisksClientListOptions contains the optional parameters for the VirtualHardDisksClient.NewListPager
//     method.
func (client *VirtualHardDisksClient) NewListPager(resourceGroupName string, options *VirtualHardDisksClientListOptions) *runtime.Pager[VirtualHardDisksClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[VirtualHardDisksClientListResponse]{
		More: func(page VirtualHardDisksClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VirtualHardDisksClientListResponse) (VirtualHardDisksClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VirtualHardDisksClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return VirtualHardDisksClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *VirtualHardDisksClient) listCreateRequest(ctx context.Context, resourceGroupName string, options *VirtualHardDisksClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualHardDisks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *VirtualHardDisksClient) listHandleResponse(resp *http.Response) (VirtualHardDisksClientListResponse, error) {
	result := VirtualHardDisksClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VirtualHardDisksListResult); err != nil {
		return VirtualHardDisksClientListResponse{}, err
	}
	return result, nil
}

// NewListAllPager - Lists all of the virtual hard disks in the specified subscription. Use the nextLink property in the response
// to get the next page of virtual hard disks.
//
// Generated from API version 2023-09-01-preview
//   - options - VirtualHardDisksClientListAllOptions contains the optional parameters for the VirtualHardDisksClient.NewListAllPager
//     method.
func (client *VirtualHardDisksClient) NewListAllPager(options *VirtualHardDisksClientListAllOptions) *runtime.Pager[VirtualHardDisksClientListAllResponse] {
	return runtime.NewPager(runtime.PagingHandler[VirtualHardDisksClientListAllResponse]{
		More: func(page VirtualHardDisksClientListAllResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VirtualHardDisksClientListAllResponse) (VirtualHardDisksClientListAllResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VirtualHardDisksClient.NewListAllPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAllCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return VirtualHardDisksClientListAllResponse{}, err
			}
			return client.listAllHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAllCreateRequest creates the ListAll request.
func (client *VirtualHardDisksClient) listAllCreateRequest(ctx context.Context, options *VirtualHardDisksClientListAllOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AzureStackHCI/virtualHardDisks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAllHandleResponse handles the ListAll response.
func (client *VirtualHardDisksClient) listAllHandleResponse(resp *http.Response) (VirtualHardDisksClientListAllResponse, error) {
	result := VirtualHardDisksClientListAllResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VirtualHardDisksListResult); err != nil {
		return VirtualHardDisksClientListAllResponse{}, err
	}
	return result, nil
}

// BeginUpdate - The operation to update a virtual hard disk.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - virtualHardDiskName - Name of the virtual hard disk
//   - options - VirtualHardDisksClientBeginUpdateOptions contains the optional parameters for the VirtualHardDisksClient.BeginUpdate
//     method.
func (client *VirtualHardDisksClient) BeginUpdate(ctx context.Context, resourceGroupName string, virtualHardDiskName string, virtualHardDisks VirtualHardDisksUpdateRequest, options *VirtualHardDisksClientBeginUpdateOptions) (*runtime.Poller[VirtualHardDisksClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, virtualHardDiskName, virtualHardDisks, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[VirtualHardDisksClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[VirtualHardDisksClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - The operation to update a virtual hard disk.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
func (client *VirtualHardDisksClient) update(ctx context.Context, resourceGroupName string, virtualHardDiskName string, virtualHardDisks VirtualHardDisksUpdateRequest, options *VirtualHardDisksClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "VirtualHardDisksClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, virtualHardDiskName, virtualHardDisks, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *VirtualHardDisksClient) updateCreateRequest(ctx context.Context, resourceGroupName string, virtualHardDiskName string, virtualHardDisks VirtualHardDisksUpdateRequest, options *VirtualHardDisksClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualHardDisks/{virtualHardDiskName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if virtualHardDiskName == "" {
		return nil, errors.New("parameter virtualHardDiskName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{virtualHardDiskName}", url.PathEscape(virtualHardDiskName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, virtualHardDisks); err != nil {
		return nil, err
	}
	return req, nil
}
