// Code generated by smithy-go-codegen DO NOT EDIT.

package observabilityadmin

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/observabilityadmin/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Lists all telemetry rules in your organization. This operation can only be
//
// called by the organization's management account or a delegated administrator
// account.
func (c *Client) ListTelemetryRulesForOrganization(ctx context.Context, params *ListTelemetryRulesForOrganizationInput, optFns ...func(*Options)) (*ListTelemetryRulesForOrganizationOutput, error) {
	if params == nil {
		params = &ListTelemetryRulesForOrganizationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTelemetryRulesForOrganization", params, optFns, c.addOperationListTelemetryRulesForOrganizationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTelemetryRulesForOrganizationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTelemetryRulesForOrganizationInput struct {

	//  The maximum number of organization telemetry rules to return in a single call.
	MaxResults *int32

	//  The token for the next set of results. A previous call generates this token.
	NextToken *string

	//  A string to filter organization telemetry rules whose names begin with the
	// specified prefix.
	RuleNamePrefix *string

	//  The list of account IDs to filter organization telemetry rules by their source
	// accounts.
	SourceAccountIds []string

	//  The list of organizational unit IDs to filter organization telemetry rules by
	// their source organizational units.
	SourceOrganizationUnitIds []string

	noSmithyDocumentSerde
}

type ListTelemetryRulesForOrganizationOutput struct {

	//  A token to resume pagination of results.
	NextToken *string

	//  A list of organization telemetry rule summaries.
	TelemetryRuleSummaries []types.TelemetryRuleSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTelemetryRulesForOrganizationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTelemetryRulesForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTelemetryRulesForOrganization{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTelemetryRulesForOrganization"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTelemetryRulesForOrganization(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTelemetryRulesForOrganizationPaginatorOptions is the paginator options for
// ListTelemetryRulesForOrganization
type ListTelemetryRulesForOrganizationPaginatorOptions struct {
	//  The maximum number of organization telemetry rules to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTelemetryRulesForOrganizationPaginator is a paginator for
// ListTelemetryRulesForOrganization
type ListTelemetryRulesForOrganizationPaginator struct {
	options   ListTelemetryRulesForOrganizationPaginatorOptions
	client    ListTelemetryRulesForOrganizationAPIClient
	params    *ListTelemetryRulesForOrganizationInput
	nextToken *string
	firstPage bool
}

// NewListTelemetryRulesForOrganizationPaginator returns a new
// ListTelemetryRulesForOrganizationPaginator
func NewListTelemetryRulesForOrganizationPaginator(client ListTelemetryRulesForOrganizationAPIClient, params *ListTelemetryRulesForOrganizationInput, optFns ...func(*ListTelemetryRulesForOrganizationPaginatorOptions)) *ListTelemetryRulesForOrganizationPaginator {
	if params == nil {
		params = &ListTelemetryRulesForOrganizationInput{}
	}

	options := ListTelemetryRulesForOrganizationPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTelemetryRulesForOrganizationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTelemetryRulesForOrganizationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTelemetryRulesForOrganization page.
func (p *ListTelemetryRulesForOrganizationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTelemetryRulesForOrganizationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTelemetryRulesForOrganization(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTelemetryRulesForOrganizationAPIClient is a client that implements the
// ListTelemetryRulesForOrganization operation.
type ListTelemetryRulesForOrganizationAPIClient interface {
	ListTelemetryRulesForOrganization(context.Context, *ListTelemetryRulesForOrganizationInput, ...func(*Options)) (*ListTelemetryRulesForOrganizationOutput, error)
}

var _ ListTelemetryRulesForOrganizationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTelemetryRulesForOrganization(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTelemetryRulesForOrganization",
	}
}
