// Code generated by smithy-go-codegen DO NOT EDIT.

package types

type AccountAccessType string

// Enum values for AccountAccessType
const (
	// Indicates that the customer is using Grafana to monitor resources in their
	// current account.
	AccountAccessTypeCurrentAccount AccountAccessType = "CURRENT_ACCOUNT"
	// Indicates that the customer is using Grafana to monitor resources in
	// organizational units.
	AccountAccessTypeOrganization AccountAccessType = "ORGANIZATION"
)

// Values returns all known values for AccountAccessType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AccountAccessType) Values() []AccountAccessType {
	return []AccountAccessType{
		"CURRENT_ACCOUNT",
		"ORGANIZATION",
	}
}

type AuthenticationProviderTypes string

// Enum values for AuthenticationProviderTypes
const (
	// Indicates that AMG workspace has AWS SSO enabled as its authentication provider.
	AuthenticationProviderTypesAwsSso AuthenticationProviderTypes = "AWS_SSO"
	// Indicates that the AMG workspace has SAML enabled as its authentication
	// provider.
	AuthenticationProviderTypesSaml AuthenticationProviderTypes = "SAML"
)

// Values returns all known values for AuthenticationProviderTypes. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (AuthenticationProviderTypes) Values() []AuthenticationProviderTypes {
	return []AuthenticationProviderTypes{
		"AWS_SSO",
		"SAML",
	}
}

type DataSourceType string

// Enum values for DataSourceType
const (
	// Amazon OpenSearch Service
	DataSourceTypeAmazonOpensearchService DataSourceType = "AMAZON_OPENSEARCH_SERVICE"
	// CloudWatch Logs
	DataSourceTypeCloudwatch DataSourceType = "CLOUDWATCH"
	// Managed Prometheus
	DataSourceTypePrometheus DataSourceType = "PROMETHEUS"
	// X-Ray
	DataSourceTypeXray DataSourceType = "XRAY"
	// Timestream
	DataSourceTypeTimestream DataSourceType = "TIMESTREAM"
	// IoT SiteWise
	DataSourceTypeSitewise DataSourceType = "SITEWISE"
	// Amazon Athena
	DataSourceTypeAthena DataSourceType = "ATHENA"
	// Redshift
	DataSourceTypeRedshift DataSourceType = "REDSHIFT"
	// IoT TwinMaker
	DataSourceTypeTwinmaker DataSourceType = "TWINMAKER"
)

// Values returns all known values for DataSourceType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (DataSourceType) Values() []DataSourceType {
	return []DataSourceType{
		"AMAZON_OPENSEARCH_SERVICE",
		"CLOUDWATCH",
		"PROMETHEUS",
		"XRAY",
		"TIMESTREAM",
		"SITEWISE",
		"ATHENA",
		"REDSHIFT",
		"TWINMAKER",
	}
}

type LicenseType string

// Enum values for LicenseType
const (
	// Grafana Enterprise License.
	LicenseTypeEnterprise LicenseType = "ENTERPRISE"
	// Grafana Enterprise Free Trial License.
	LicenseTypeEnterpriseFreeTrial LicenseType = "ENTERPRISE_FREE_TRIAL"
)

// Values returns all known values for LicenseType. Note that this can be expanded
// in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (LicenseType) Values() []LicenseType {
	return []LicenseType{
		"ENTERPRISE",
		"ENTERPRISE_FREE_TRIAL",
	}
}

type NotificationDestinationType string

// Enum values for NotificationDestinationType
const (
	// AWS Simple Notification Service
	NotificationDestinationTypeSns NotificationDestinationType = "SNS"
)

// Values returns all known values for NotificationDestinationType. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (NotificationDestinationType) Values() []NotificationDestinationType {
	return []NotificationDestinationType{
		"SNS",
	}
}

type PermissionType string

// Enum values for PermissionType
const (
	// Customer Managed
	PermissionTypeCustomerManaged PermissionType = "CUSTOMER_MANAGED"
	// Service Managed
	PermissionTypeServiceManaged PermissionType = "SERVICE_MANAGED"
)

// Values returns all known values for PermissionType. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (PermissionType) Values() []PermissionType {
	return []PermissionType{
		"CUSTOMER_MANAGED",
		"SERVICE_MANAGED",
	}
}

type Role string

// Enum values for Role
const (
	// Role Admin.
	RoleAdmin Role = "ADMIN"
	// Role Editor.
	RoleEditor Role = "EDITOR"
	// Role Viewer.
	RoleViewer Role = "VIEWER"
)

// Values returns all known values for Role. Note that this can be expanded in the
// future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (Role) Values() []Role {
	return []Role{
		"ADMIN",
		"EDITOR",
		"VIEWER",
	}
}

type SamlConfigurationStatus string

// Enum values for SamlConfigurationStatus
const (
	// Indicates that SAML on an AMG workspace is enabled and has been configured.
	SamlConfigurationStatusConfigured SamlConfigurationStatus = "CONFIGURED"
	// Indicates that SAML on an AMG workspace is enabled but has not been configured.
	SamlConfigurationStatusNotConfigured SamlConfigurationStatus = "NOT_CONFIGURED"
)

// Values returns all known values for SamlConfigurationStatus. Note that this can
// be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (SamlConfigurationStatus) Values() []SamlConfigurationStatus {
	return []SamlConfigurationStatus{
		"CONFIGURED",
		"NOT_CONFIGURED",
	}
}

type UpdateAction string

// Enum values for UpdateAction
const (
	// Add permissions.
	UpdateActionAdd UpdateAction = "ADD"
	// Revoke permissions.
	UpdateActionRevoke UpdateAction = "REVOKE"
)

// Values returns all known values for UpdateAction. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UpdateAction) Values() []UpdateAction {
	return []UpdateAction{
		"ADD",
		"REVOKE",
	}
}

type UserType string

// Enum values for UserType
const (
	// SSO user.
	UserTypeSsoUser UserType = "SSO_USER"
	// SSO group.
	UserTypeSsoGroup UserType = "SSO_GROUP"
)

// Values returns all known values for UserType. Note that this can be expanded in
// the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (UserType) Values() []UserType {
	return []UserType{
		"SSO_USER",
		"SSO_GROUP",
	}
}

type ValidationExceptionReason string

// Enum values for ValidationExceptionReason
const (
	ValidationExceptionReasonUnknownOperation      ValidationExceptionReason = "UNKNOWN_OPERATION"
	ValidationExceptionReasonCannotParse           ValidationExceptionReason = "CANNOT_PARSE"
	ValidationExceptionReasonFieldValidationFailed ValidationExceptionReason = "FIELD_VALIDATION_FAILED"
	ValidationExceptionReasonOther                 ValidationExceptionReason = "OTHER"
)

// Values returns all known values for ValidationExceptionReason. Note that this
// can be expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (ValidationExceptionReason) Values() []ValidationExceptionReason {
	return []ValidationExceptionReason{
		"UNKNOWN_OPERATION",
		"CANNOT_PARSE",
		"FIELD_VALIDATION_FAILED",
		"OTHER",
	}
}

type WorkspaceStatus string

// Enum values for WorkspaceStatus
const (
	// Workspace is active.
	WorkspaceStatusActive WorkspaceStatus = "ACTIVE"
	// Workspace is being created.
	WorkspaceStatusCreating WorkspaceStatus = "CREATING"
	// Workspace is being deleted.
	WorkspaceStatusDeleting WorkspaceStatus = "DELETING"
	// Workspace is in an invalid state, it can only and should be deleted.
	WorkspaceStatusFailed WorkspaceStatus = "FAILED"
	// Workspace is being updated.
	WorkspaceStatusUpdating WorkspaceStatus = "UPDATING"
	// Workspace is being upgraded to enterprise.
	WorkspaceStatusUpgrading WorkspaceStatus = "UPGRADING"
	// Workspace deletion failed.
	WorkspaceStatusDeletionFailed WorkspaceStatus = "DELETION_FAILED"
	// Workspace creation failed.
	WorkspaceStatusCreationFailed WorkspaceStatus = "CREATION_FAILED"
	// Workspace update failed.
	WorkspaceStatusUpdateFailed WorkspaceStatus = "UPDATE_FAILED"
	// Workspace upgrade failed.
	WorkspaceStatusUpgradeFailed WorkspaceStatus = "UPGRADE_FAILED"
	// Failed to remove enterprise license from workspace.
	WorkspaceStatusLicenseRemovalFailed WorkspaceStatus = "LICENSE_REMOVAL_FAILED"
	// Workspace version is being updated.
	WorkspaceStatusVersionUpdating WorkspaceStatus = "VERSION_UPDATING"
	// Workspace version update failed.
	WorkspaceStatusVersionUpdateFailed WorkspaceStatus = "VERSION_UPDATE_FAILED"
)

// Values returns all known values for WorkspaceStatus. Note that this can be
// expanded in the future, and so it is only as up to date as the client.
//
// The ordering of this slice is not guaranteed to be stable across updates.
func (WorkspaceStatus) Values() []WorkspaceStatus {
	return []WorkspaceStatus{
		"ACTIVE",
		"CREATING",
		"DELETING",
		"FAILED",
		"UPDATING",
		"UPGRADING",
		"DELETION_FAILED",
		"CREATION_FAILED",
		"UPDATE_FAILED",
		"UPGRADE_FAILED",
		"LICENSE_REMOVAL_FAILED",
		"VERSION_UPDATING",
		"VERSION_UPDATE_FAILED",
	}
}
