// Code generated by smithy-go-codegen DO NOT EDIT.

package codeartifact

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codeartifact/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the package origin configuration for a package group.
//
// The package origin configuration determines how new versions of a package can
// be added to a repository. You can allow or block direct publishing of new
// package versions, or ingestion and retaining of new package versions from an
// external connection or upstream source. For more information about package group
// origin controls and configuration, see [Package group origin controls]in the CodeArtifact User Guide.
//
// [Package group origin controls]: https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-origin-controls.html
func (c *Client) UpdatePackageGroupOriginConfiguration(ctx context.Context, params *UpdatePackageGroupOriginConfigurationInput, optFns ...func(*Options)) (*UpdatePackageGroupOriginConfigurationOutput, error) {
	if params == nil {
		params = &UpdatePackageGroupOriginConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdatePackageGroupOriginConfiguration", params, optFns, c.addOperationUpdatePackageGroupOriginConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdatePackageGroupOriginConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdatePackageGroupOriginConfigurationInput struct {

	//  The name of the domain which contains the package group for which to update
	// the origin configuration.
	//
	// This member is required.
	Domain *string

	//  The pattern of the package group for which to update the origin configuration.
	//
	// This member is required.
	PackageGroup *string

	// The repository name and restrictions to add to the allowed repository list of
	// the specified package group.
	AddAllowedRepositories []types.PackageGroupAllowedRepository

	//  The 12-digit account number of the Amazon Web Services account that owns the
	// domain. It does not include dashes or spaces.
	DomainOwner *string

	// The repository name and restrictions to remove from the allowed repository list
	// of the specified package group.
	RemoveAllowedRepositories []types.PackageGroupAllowedRepository

	//  The origin configuration settings that determine how package versions can
	// enter repositories.
	Restrictions map[string]types.PackageGroupOriginRestrictionMode

	noSmithyDocumentSerde
}

type UpdatePackageGroupOriginConfigurationOutput struct {

	// Information about the updated allowed repositories after processing the request.
	AllowedRepositoryUpdates map[string]map[string][]string

	//  The package group and information about it after processing the request.
	PackageGroup *types.PackageGroupDescription

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdatePackageGroupOriginConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdatePackageGroupOriginConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdatePackageGroupOriginConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdatePackageGroupOriginConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdatePackageGroupOriginConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdatePackageGroupOriginConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdatePackageGroupOriginConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdatePackageGroupOriginConfiguration",
	}
}
