/**
 * FreeRDP: A Remote Desktop Protocol Implementation
 * Echo Virtual Channel Extension
 *
 * Copyright 2014 Vic Lee
 * Copyright 2015 Thincast Technologies GmbH
 * Copyright 2015 DI (FH) Martin Haimberger <martin.haimberger@thincast.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *	 http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef FREERDP_CHANNEL_ECHO_SERVER_H
#define FREERDP_CHANNEL_ECHO_SERVER_H

#include <freerdp/channels/wtsvc.h>

#ifdef __cplusplus
extern "C"
{
#endif

	typedef enum ECHO_SERVER_OPEN_RESULT
	{
		ECHO_SERVER_OPEN_RESULT_OK = 0,
		ECHO_SERVER_OPEN_RESULT_CLOSED = 1,
		ECHO_SERVER_OPEN_RESULT_NOTSUPPORTED = 2,
		ECHO_SERVER_OPEN_RESULT_ERROR = 3
	} ECHO_SERVER_OPEN_RESULT;

	typedef struct s_echo_server_context echo_server_context;

	typedef BOOL (*psEchoServerChannelIdAssigned)(echo_server_context* context, UINT32 channelId);

	typedef UINT (*psEchoServerOpen)(echo_server_context* context);
	typedef UINT (*psEchoServerClose)(echo_server_context* context);
	typedef BOOL (*psEchoServerRequest)(echo_server_context* context, const BYTE* buffer,
	                                    UINT32 length);

	typedef UINT (*psEchoServerOpenResult)(echo_server_context* context,
	                                       ECHO_SERVER_OPEN_RESULT result);
	typedef UINT (*psEchoServerResponse)(echo_server_context* context, const BYTE* buffer,
	                                     UINT32 length);

	struct s_echo_server_context
	{
		HANDLE vcm;

		/* Server self-defined pointer. */
		void* data;

		/*** APIs called by the server. ***/
		/**
		 * Open the echo channel.
		 */
		WINPR_ATTR_NODISCARD psEchoServerOpen Open;
		/**
		 * Close the echo channel.
		 */
		WINPR_ATTR_NODISCARD psEchoServerClose Close;
		/**
		 * Send echo request PDU.
		 */
		WINPR_ATTR_NODISCARD psEchoServerRequest Request;

		/*** Callbacks registered by the server. ***/
		/**
		 * Indicate whether the channel is opened successfully.
		 */
		WINPR_ATTR_NODISCARD psEchoServerOpenResult OpenResult;
		/**
		 * Receive echo response PDU.
		 */
		WINPR_ATTR_NODISCARD psEchoServerResponse Response;

		rdpContext* rdpcontext;

		/**
		 * Callback, when the channel got its id assigned.
		 */
		psEchoServerChannelIdAssigned ChannelIdAssigned;
	};

	FREERDP_API void echo_server_context_free(echo_server_context* context);

	WINPR_ATTR_MALLOC(echo_server_context_free, 1)
	WINPR_ATTR_NODISCARD
	FREERDP_API echo_server_context* echo_server_context_new(HANDLE vcm);

#ifdef __cplusplus
}
#endif

#endif /* FREERDP_CHANNEL_ECHO_SERVER_H */
