# -*- coding: utf-8 -*-
#
# Read the Docs Template documentation build configuration file, created by
# sphinx-quickstart on Tue Aug 26 14:19:49 2014.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# If this is not inserted at the beginning of the list, our 'jira' ticket
# extension is hidden by the system 'jira' API, if it exists.
sys.path.insert(0, os.path.abspath('extensions'))
sys.path.append(os.path.join(os.path.dirname(os.path.dirname(os.path.abspath(__file__))), 'src', 'condor_tests'))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
# Note: This setting is only for man page build see same variable in
#       full_conf.py for html excludes
extensions = [
    'ticket',
    'macro',
    'macro-def',
    'subcom',
    'subcom-def',
    'index',
    'jira',
    'tool',
    'ad-attr',
    'hidden',
    'dag-cmd',
    'man-page-dummies',
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
# Note: This setting is only for man page build see same variable in
#       full_conf.py for html excludes
master_doc = 'man-pages/index'

# General information about the project.
project = u'HTCondor Manual'
copyright = u'1990-2026, Center for High Throughput Computing, Computer \
Sciences Department, University of Wisconsin-Madison, Madison, WI, US. \
Licensed under the Apache License, Version 2.0.'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The full version, including alpha/beta/rc tags.
release = '25.6.1'

rst_epilog = """
.. |release_date| replace:: January 29, 2026

.. role:: config(code)
    :language: condor-config
.. role:: classad(code)
    :language: condor-classad
.. role:: ad-expr(code)
    :language: condor-classad-expr
.. role:: jdl(code)
    :language: condor-submit
.. role:: dag(code)
    :language: condor-dagman
"""

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# Note: This setting is only for man page build see same variable in
#       full_conf.py for html excludes
exclude_patterns = [f for f in os.listdir() if f != "man-pages"]

# The reST default role (used for this markup: `text`) to use for all
# documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'colorful'

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# -- Options for manual page output ---------------------------------------

# Short list of man pages to build which is used to add generice info
MAN_PAGES = [
        ('classad_eval', 1),
        ('classads', 1),
        ('condor_adstash', 1),
        ('condor_advertise', 1),
        ('condor_check_password', 1),
        ('condor_check_userlogs', 1),
        ('condor_chirp', 1),
        ('condor_configure', 1),
        ('condor_config_val', 1),
        ('condor_continue', 1),
        ('condor_dagman', 1),
        ('condor_dag_checker', 1),
        ('condor_drain', 1),
        ('condor_evicted_files', 1),
        ('condor_fetchlog', 1),
        ('condor_findhost', 1),
        ('condor_gather_info', 1),
        ('condor_gpu_discovery', 1),
        ('condor_history', 1),
        ('condor_hold', 1),
        ('condor_install', 1),
        ('condor_job_router_info', 1),
        ('condor_master', 1),
        ('condor_now', 1),
        ('condor_off', 1),
        ('condor_on', 1),
        ('condor_ping', 1),
        ('condor_pool_job_report', 1),
        ('condor_power', 1),
        ('condor_preen', 1),
        ('condor_prio', 1),
        ('condor_procd', 1),
        ('condor_q', 1),
        ('condor_qusers', 1),
        ('condor_qedit', 1),
        ('condor_qsub', 1),
        ('condor_reconfig', 1),
        ('condor_release', 1),
        ('condor_remote_cluster', 1),
        ('condor_reschedule', 1),
        ('condor_restart', 1),
        ('condor_rm', 1),
        ('condor_rmdir', 1),
        ('condor_router_history', 1),
        ('condor_router_q', 1),
        ('condor_router_rm', 1),
        ('condor_run', 1),
        ('condor_set_shutdown', 1),
        ('condor_sos', 1),
        ('condor_ssh_start', 1),
        ('condor_ssh_to_job', 1),
        ('condor_ssl_fingerprint', 1),
        #('condor_stats', 1),
        ('condor_status', 1),
        ('condor_store_cred', 1),
        ('condor_submit', 1),
        ('condor_submit_dag', 1),
        ('condor_suspend', 1),
        ('condor_tail', 1),
        ('condor_test_token', 1),
        ('condor_token_create', 1),
        ('condor_token_fetch', 1),
        ('condor_token_list', 1),
        ('condor_token_request', 1),
        ('condor_token_request_approve', 1),
        ('condor_token_request_auto_approve', 1),
        ('condor_token_request_list', 1),
        ('condor_top', 1),
        ('condor_transfer_data', 1),
        ('condor_transform_ads', 1),
        ('condor_update_machine_ad', 1),
        ('condor_updates_stats', 1),
        ('condor_upgrade_check', 1),
        ('condor_urlfetch', 1),
        ('condor_userlog', 1),
        ('condor_userprio', 1),
        ('condor_vacate', 1),
        ('condor_vacate_job', 1),
        ('condor_version', 1),
        ('condor_wait', 1),
        ('condor_watch_q', 1),
        ('condor_who', 1),
        ('get_htcondor', 1),
        ('gidd_alloc', 1),
        ('htcondor', 1),
        ('procd_ctl', 1)
]

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
# e.g. ('man-pages/condor_chirp', 'condor_chirp', u'HTCondor Manual', [u'HTCondor Team'], 1)
man_pages = [
    (f'man-pages/{item[0]}', item[0], u'HTCondor Manual', [u'HTCondor Team'], item[1]) for item in MAN_PAGES
]

# If true, show URL addresses after external links.
# man_show_urls = False

# -- conf.py contains common configuration and man pages configuration
# -- full_conf.py contains configuration for the whole manual
sys.path.append(os.path.dirname(__file__))
MANPAGES = os.environ.get('MANPAGES') == 'True'
if not MANPAGES:
    from full_conf import *
