# How to generate documentation and stub

This subdirectory contains all the required tools and script to generate the documentation for the CamiTK bindings and the stub file for providing interactive helps during coding in VSCode.

This is done in three steps:

1. extract the docstrings automatically from the doxygen documentation using pybind_mkdoc
2. manually add documentation to python bindings
3. generate the stub from the camitk python module

## Dependencies

The first steps requires pybond11_mkdoc to generate docstrings while the last steps requires pybind11-stubgen.

## Install

```bash
python -m venv .venv
.venv/bin/pip install git+https://github.com/pybind/pybind11_mkdoc.git@master
.venv/bin/pip install pybind11-stubgen numpy 
sudo apt install libclang-20-dev
```
!!! Note libclang-dev >= 20 is required by pybind11_mkdoc

!!! Note numpy is required by camitk

## Step 1: extract documentation strings

- modify/setup the paths (especially CamiTK, Clang, Qt and VTK version) in the `generate-docstrings.sh` script
- run ./make-docstrings-for-camitk-python-bindings.sh

This generates the `docstring.h` file.

## Step 2: add docstring to exported function

For instance:

```cpp
  py::class_<camitk::Application> application(m, "Application", DOC(camitk_Application));

    application.def_static("getAction", &camitk::Application::getAction,
        py::return_value_policy::reference,
        DOC(camitk_Application_getAction));

        ...
```

## 5. Generate stub files

```bash
PYTHONPATH=../camitk/build/lib .venv/bin/pybind11-stubgen camitk --output-dir stubs
```